/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;

public class ProxyInfo {
    private final Proxy proxy;
    private final boolean secure;

    public ProxyInfo(Proxy proxy, boolean secure) {
        this.proxy = proxy;
        this.secure = secure;
    }

    public ProxyInfo(String host, int port, Proxy.Type type, boolean secure) throws UnknownHostException {
        this.secure = secure;
        InetAddress address = InetAddress.getByName(host);
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        this.proxy = new Proxy(type, socketAddress);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public InetAddress getAddress() {
        return this.getSocketAddress().getAddress();
    }

    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.proxy.address();
    }

    public int getPort() {
        return this.getSocketAddress().getPort();
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

