/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util.jar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.xbean.osgi.bundle.util.jar.BundleJarEntry;
import org.osgi.framework.Bundle;

public class BundleJarFile
extends JarFile {
    private static final File DUMMY_JAR_FILE;
    private final Bundle bundle;
    private boolean manifestLoaded = false;
    private Manifest manifest;

    public BundleJarFile(Bundle bundle) throws IOException {
        super(DUMMY_JAR_FILE);
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        if (!this.manifestLoaded) {
            URL manifestURL = this.bundle.getEntry("META-INF/MANIFEST.MF");
            if (manifestURL != null) {
                InputStream in = null;
                try {
                    in = manifestURL.openStream();
                    this.manifest = new Manifest(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            this.manifestLoaded = true;
        }
        return this.manifest;
    }

    public BundleJarEntry getBundleJarEntry(String name) {
        URL url = this.bundle.getEntry(name);
        if (url == null) {
            return null;
        }
        return new BundleJarEntry(name, url, this.getManifestSafe());
    }

    @Override
    public JarEntry getJarEntry(String name) {
        return this.getBundleJarEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        return this.getBundleJarEntry(name);
    }

    public Enumeration entries() {
        Manifest manifest = this.getManifestSafe();
        Enumeration e = this.bundle.findEntries("/", "*", true);
        LinkedList<BundleJarEntry> entries = new LinkedList<BundleJarEntry>();
        while (e.hasMoreElements()) {
            URL entryURL = (URL)e.nextElement();
            entries.add(new BundleJarEntry(entryURL.getPath(), entryURL, manifest));
        }
        return Collections.enumeration(entries);
    }

    @Override
    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        BundleJarEntry entry = zipEntry instanceof BundleJarEntry ? (BundleJarEntry)zipEntry : this.getBundleJarEntry(zipEntry.getName());
        if (entry == null) {
            throw new IOException("Entry not found: name=" + zipEntry.getName());
        }
        if (entry.isDirectory()) {
            return new EmptyInputStream();
        }
        return entry.getEntryURL().openStream();
    }

    @Override
    public String getName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public void close() throws IOException {
    }

    private Manifest getManifestSafe() {
        Manifest manifest = null;
        try {
            manifest = this.getManifest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return manifest;
    }

    private static File createTempFile() throws IOException {
        File tempFile = File.createTempFile("geronimo-fileutils", ".tmpfile");
        tempFile.deleteOnExit();
        return tempFile;
    }

    static {
        try {
            DUMMY_JAR_FILE = BundleJarFile.createTempFile();
            new JarOutputStream((OutputStream)new FileOutputStream(DUMMY_JAR_FILE), new Manifest()).close();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(byte[] b) {
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            return -1;
        }

        @Override
        public long skip(long n) {
            return 0L;
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() {
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public synchronized void reset() {
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

