/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.util.TypeLiteral;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.config.OwbParametrizedTypeImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.ArrayUtil;

public class EventMetadataImpl
implements EventMetadata,
Serializable {
    private static final long serialVersionUID = -6401875861180683988L;
    private final Type type;
    private final Type selectType;
    private final InjectionPoint injectionPoint;
    private final Set<Annotation> qualifiers;
    private transient WebBeansContext webBeansContext;

    public EventMetadataImpl(Type selectType, Type type, InjectionPoint injectionPoint, Annotation[] qualifiers, WebBeansContext context) {
        Set<AnyLiteral> completeQualifiers;
        context.getAnnotationManager().checkQualifierConditions(qualifiers);
        this.selectType = selectType;
        this.type = type;
        this.injectionPoint = injectionPoint;
        this.webBeansContext = context;
        if (qualifiers.length == 0) {
            completeQualifiers = Collections.singleton(AnyLiteral.INSTANCE);
        } else {
            completeQualifiers = new HashSet<Annotation>(Arrays.asList(qualifiers));
            if (completeQualifiers.size() != qualifiers.length) {
                throw new IllegalArgumentException("duplicate qualifier");
            }
            if (!completeQualifiers.contains((Object)AnyLiteral.INSTANCE)) {
                completeQualifiers.add(AnyLiteral.INSTANCE);
            }
        }
        this.qualifiers = Collections.unmodifiableSet(completeQualifiers);
    }

    public Type getType() {
        if (this.selectType != null && ParameterizedType.class.isInstance(this.selectType)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(this.selectType);
            Type rawType = parameterizedType.getRawType();
            if (rawType == this.type) {
                return this.selectType;
            }
            if (rawType == List.class && this.type == ArrayList.class) {
                return new OwbParametrizedTypeImpl(parameterizedType.getOwnerType(), this.type, parameterizedType.getActualTypeArguments());
            }
            if (rawType == Set.class && this.type == HashSet.class) {
                return new OwbParametrizedTypeImpl(parameterizedType.getOwnerType(), this.type, parameterizedType.getActualTypeArguments());
            }
            if (rawType == Map.class && (this.type == HashMap.class || this.type == ConcurrentHashMap.class || this.type == TreeMap.class)) {
                return new OwbParametrizedTypeImpl(parameterizedType.getOwnerType(), this.type, parameterizedType.getActualTypeArguments());
            }
        }
        return this.type;
    }

    public Type validatedType() {
        return this.selectType != null ? this.selectType : this.type;
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public EventMetadataImpl select(Annotation ... bindings) {
        return this.select(this.type, bindings);
    }

    public EventMetadataImpl select(TypeLiteral<?> subtype, Annotation ... bindings) {
        this.webBeansContext.getWebBeansUtil().checkTypeVariables(subtype);
        return this.select(subtype.getType(), bindings);
    }

    public EventMetadataImpl select(Type subtype, Annotation ... bindings) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(bindings);
        Set<Annotation> newQualifiers = ArrayUtil.asSet(bindings);
        newQualifiers.addAll(this.qualifiers);
        return new EventMetadataImpl(this.type, subtype, this.injectionPoint, newQualifiers.toArray(new Annotation[newQualifiers.size()]), this.webBeansContext);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.webBeansContext = WebBeansContext.currentInstance();
    }
}

