/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config.annotations;

import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface TypedConfig<T> {
    @NotNull
    public Class<T> getType();

    @NotNull
    public T getConfig();

    @NotNull
    public Map<String, Object> getConfigMap();

    default public <U> Stream<TypedConfig<U>> stream(@NotNull Class<U> otherType) {
        if (otherType.equals(this.getType())) {
            return Stream.of(this);
        }
        return Stream.empty();
    }

    default public <U> Stream<U> configStream(@NotNull Class<U> otherType) {
        return this.stream(otherType).map(TypedConfig::getConfig);
    }
}

