/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.AbstractConfigTypeReflectionProvider;
import org.apache.sling.testing.mock.osgi.config.annotations.AutoConfig;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigCollection;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigType;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigTypes;
import org.apache.sling.testing.mock.osgi.config.annotations.SetConfig;
import org.apache.sling.testing.mock.osgi.config.annotations.SetConfigs;
import org.apache.sling.testing.mock.osgi.config.annotations.TypedConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigAnnotationUtil {
    private static final Set<Class<? extends Annotation>> EXCLUDE_FEATURE_ANNOTATIONS = Set.of(ConfigTypes.class, ConfigType.class, SetConfigs.class, SetConfig.class, AutoConfig.class);

    private ConfigAnnotationUtil() {
    }

    public static Stream<Annotation> findConfigTypeAnnotations(@NotNull AnnotatedElement element) {
        return ConfigAnnotationUtil.findConfigTypeAnnotations(element, null);
    }

    public static Stream<Annotation> findConfigTypeAnnotations(@NotNull AnnotatedElement element, @Nullable ConfigTypePredicate configTypePredicate) {
        return Stream.of(element.getAnnotations()).flatMap(ConfigAnnotationUtil::flattenAnnotation).filter(ConfigAnnotationUtil.configTypeAnnotationFilter(configTypePredicate));
    }

    public static Stream<Annotation> findConfigTypeAnnotations(@NotNull Collection<Annotation> annotations) {
        return ConfigAnnotationUtil.findConfigTypeAnnotations(annotations, null);
    }

    public static Stream<Annotation> findConfigTypeAnnotations(@NotNull Collection<Annotation> annotations, @Nullable ConfigTypePredicate configTypePredicate) {
        return annotations.stream().flatMap(ConfigAnnotationUtil::flattenAnnotation).filter(ConfigAnnotationUtil.configTypeAnnotationFilter(configTypePredicate));
    }

    public static Stream<SetConfig> findUpdateConfigAnnotations(@NotNull AnnotatedElement element) {
        return Stream.of(element.getAnnotations()).flatMap(ConfigAnnotationUtil::flattenAnnotation).filter(annotation -> SetConfig.class.isAssignableFrom(annotation.annotationType())).map(SetConfig.class::cast);
    }

    public static Stream<SetConfig> findUpdateConfigAnnotations(@NotNull Collection<Annotation> annotations) {
        return annotations.stream().flatMap(ConfigAnnotationUtil::flattenAnnotation).filter(annotation -> SetConfig.class.isAssignableFrom(annotation.annotationType())).map(SetConfig.class::cast);
    }

    private static Stream<Annotation> flattenAnnotation(@NotNull Annotation annotation) {
        if (ConfigTypes.class.isAssignableFrom(annotation.annotationType())) {
            return Stream.of(((ConfigTypes)annotation).value());
        }
        if (SetConfigs.class.isAssignableFrom(annotation.annotationType())) {
            return Stream.of(((SetConfigs)annotation).value());
        }
        return Stream.of(annotation);
    }

    public static boolean isValidConfigType(@NotNull Class<?> configType) {
        return (configType.isAnnotation() || configType.isInterface()) && AbstractConfigTypeReflectionProvider.getInstance(configType).isValidConfigType() && EXCLUDE_FEATURE_ANNOTATIONS.stream().noneMatch(excluded -> excluded.isAssignableFrom(configType));
    }

    public static Predicate<Annotation> configTypeAnnotationFilter(@Nullable ConfigTypePredicate configTypePredicate) {
        ConfigTypePredicate primary = (parent, configType) -> ConfigAnnotationUtil.isValidConfigType(configType);
        ConfigTypePredicate andThen = Optional.ofNullable(configTypePredicate).orElse((parentAnnotation, configType) -> true);
        return annotation -> {
            if (ConfigType.class.isAssignableFrom(annotation.annotationType())) {
                ConfigType parentAnnotation = (ConfigType)annotation;
                return primary.and(andThen).test(Optional.of(parentAnnotation), parentAnnotation.type());
            }
            return primary.and(andThen).test(Optional.empty(), annotation.annotationType());
        };
    }

    public static Optional<Class<?>> determineSupportedConfigType(@NotNull Class<?> type) {
        if (type.isArray()) {
            return ConfigAnnotationUtil.determineSupportedConfigType(type.getComponentType());
        }
        if (type.isAnnotation() || type.isInterface()) {
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public static <T> T[] resolveParameterToArray(@NotNull ConfigCollection configCollection, @NotNull Class<T> configType) {
        return configCollection.configStream(configType).toArray(size -> (Object[])Array.newInstance(configType, size));
    }

    public static <T> Optional<TypedConfig<T>> resolveParameterToTypedConfig(@NotNull ConfigCollection configCollection, @NotNull Class<T> parameterConfigType, @NotNull Class<?>[] signatureParameterTypes, int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex >= signatureParameterTypes.length || !signatureParameterTypes[parameterIndex].isAssignableFrom(parameterConfigType)) {
            return Optional.empty();
        }
        long skip = Stream.of(signatureParameterTypes).limit(parameterIndex).filter(parameterConfigType::equals).count();
        return configCollection.stream(parameterConfigType).skip(skip).findFirst();
    }

    public static <T> Optional<T> resolveParameterToValue(@NotNull ConfigCollection configCollection, @NotNull Class<T> parameterConfigType, @NotNull Class<?>[] signatureParameterTypes, int parameterIndex) {
        return ConfigAnnotationUtil.resolveParameterToTypedConfig(configCollection, parameterConfigType, signatureParameterTypes, parameterIndex).map(TypedConfig::getConfig);
    }

    public static <T> Optional<Map<String, Object>> resolveParameterToConfigMap(@NotNull ConfigCollection configCollection, @NotNull Class<T> parameterConfigType, @NotNull Class<?>[] signatureParameterTypes, int parameterIndex) {
        return ConfigAnnotationUtil.resolveParameterToTypedConfig(configCollection, parameterConfigType, signatureParameterTypes, parameterIndex).map(TypedConfig::getConfigMap);
    }

    @FunctionalInterface
    public static interface ConfigTypePredicate
    extends BiPredicate<Optional<ConfigType>, Class<?>> {
    }
}

