/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.apache.sling.testing.mock.osgi.MockServiceRegistration;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

class MockServiceReference<T>
implements ServiceReference<T> {
    private final Bundle bundle;
    private final MockServiceRegistration<T> serviceRegistration;
    private volatile Comparable<Object> comparable;

    public MockServiceReference(Bundle bundle, MockServiceRegistration<T> serviceRegistration) {
        this.bundle = bundle;
        this.serviceRegistration = serviceRegistration;
        this.comparable = this.buildComparable();
    }

    private Comparable<Object> buildComparable() {
        Map<String, Object> props = this.serviceRegistration.getPropertiesAsMap();
        return ServiceUtil.getComparableForServiceRanking(props, (Order)Order.ASCENDING);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setProperty(String key, Object value) {
        this.serviceRegistration.getProperties().put(key, value);
        this.comparable = this.buildComparable();
    }

    public Dictionary<String, Object> getProperties() {
        return this.serviceRegistration.getProperties();
    }

    public Object getProperty(String key) {
        return this.serviceRegistration.getProperties().get(key);
    }

    public String[] getPropertyKeys() {
        Dictionary<String, Object> props = this.serviceRegistration.getProperties();
        return Collections.list(props.keys()).toArray(new String[props.size()]);
    }

    public int hashCode() {
        return this.comparable.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockServiceReference)) {
            return false;
        }
        return this.comparable.equals(((MockServiceReference)obj).comparable);
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof MockServiceReference)) {
            return 0;
        }
        return this.comparable.compareTo(((MockServiceReference)obj).comparable);
    }

    long getServiceId() {
        Number serviceID = (Number)this.getProperty("service.id");
        if (serviceID != null) {
            return serviceID.longValue();
        }
        return 0L;
    }

    int getServiceRanking() {
        Number serviceRanking = (Number)this.getProperty("service.ranking");
        if (serviceRanking != null) {
            return serviceRanking.intValue();
        }
        return 0;
    }

    T getService() {
        return this.serviceRegistration.getService();
    }

    public Bundle[] getUsingBundles() {
        throw new UnsupportedOperationException();
    }

    public boolean isAssignableTo(Bundle otherBundle, String className) {
        throw new UnsupportedOperationException();
    }
}

