/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.context;

import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.ContextPlugin;
import org.apache.sling.testing.mock.osgi.context.ContextPlugins;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContextPluginsTest {
    private OsgiContext context = new OsgiContext();
    @Mock
    private ContextPlugin plugin1;
    @Mock
    private ContextPlugin plugin2;
    @Mock
    private ContextCallback callback1;
    @Mock
    private ContextCallback callback2;

    @Test
    public void testConstructorSetUp() throws Exception {
        ContextPlugins underTest = new ContextPlugins(this.callback1);
        Assert.assertEquals((long)1L, (long)underTest.getPlugins().size());
        underTest.executeAfterSetUpCallback((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback1, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
    }

    @Test
    public void testConstructorSetUpTearDown() throws Exception {
        ContextPlugins underTest = new ContextPlugins(this.callback1, this.callback2);
        Assert.assertEquals((long)2L, (long)underTest.getPlugins().size());
        underTest.executeAfterSetUpCallback((OsgiContextImpl)this.context);
        underTest.executeBeforeTearDownCallback((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback1, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback2, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
    }

    @Test
    public void testExecuteBeforeSetUpCallback() throws Exception {
        ContextPlugins underTest = new ContextPlugins();
        underTest.addPlugin(new ContextPlugin[]{this.plugin1, this.plugin2, null});
        Assert.assertEquals((long)2L, (long)underTest.getPlugins().size());
        underTest.executeBeforeSetUpCallback((OsgiContextImpl)this.context);
        ((ContextPlugin)Mockito.verify((Object)this.plugin1, (VerificationMode)Mockito.times((int)1))).beforeSetUp((OsgiContextImpl)this.context);
        ((ContextPlugin)Mockito.verify((Object)this.plugin2, (VerificationMode)Mockito.times((int)1))).beforeSetUp((OsgiContextImpl)this.context);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.plugin1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.plugin2});
    }

    @Test
    public void testExecuteAfterSetUpCallback() throws Exception {
        ContextPlugins underTest = new ContextPlugins();
        underTest.addPlugin(new ContextPlugin[]{this.plugin1, this.plugin2, null});
        Assert.assertEquals((long)2L, (long)underTest.getPlugins().size());
        underTest.executeAfterSetUpCallback((OsgiContextImpl)this.context);
        ((ContextPlugin)Mockito.verify((Object)this.plugin1, (VerificationMode)Mockito.times((int)1))).afterSetUp((OsgiContextImpl)this.context);
        ((ContextPlugin)Mockito.verify((Object)this.plugin2, (VerificationMode)Mockito.times((int)1))).afterSetUp((OsgiContextImpl)this.context);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.plugin1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.plugin2});
    }

    @Test
    public void testExecuteBeforeTearDownCallback() throws Exception {
        ContextPlugins underTest = new ContextPlugins();
        underTest.addPlugin(new ContextPlugin[]{this.plugin1, this.plugin2, null});
        Assert.assertEquals((long)2L, (long)underTest.getPlugins().size());
        underTest.executeBeforeTearDownCallback((OsgiContextImpl)this.context);
        ((ContextPlugin)Mockito.verify((Object)this.plugin1, (VerificationMode)Mockito.times((int)1))).beforeTearDown((OsgiContextImpl)this.context);
        ((ContextPlugin)Mockito.verify((Object)this.plugin2, (VerificationMode)Mockito.times((int)1))).beforeTearDown((OsgiContextImpl)this.context);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.plugin1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.plugin2});
    }

    @Test
    public void testExecuteAfterTearDownCallback() throws Exception {
        ContextPlugins underTest = new ContextPlugins();
        underTest.addPlugin(new ContextPlugin[]{this.plugin1, this.plugin2, null});
        Assert.assertEquals((long)2L, (long)underTest.getPlugins().size());
        underTest.executeAfterTearDownCallback((OsgiContextImpl)this.context);
        ((ContextPlugin)Mockito.verify((Object)this.plugin1, (VerificationMode)Mockito.times((int)1))).afterTearDown((OsgiContextImpl)this.context);
        ((ContextPlugin)Mockito.verify((Object)this.plugin2, (VerificationMode)Mockito.times((int)1))).afterTearDown((OsgiContextImpl)this.context);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.plugin1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.plugin2});
    }

    @Test
    public void testAddBeforeSetUpCallback() throws Exception {
        ContextPlugins underTest = new ContextPlugins();
        underTest.addBeforeSetUpCallback(new ContextCallback[]{this.callback1, this.callback2, null});
        Assert.assertEquals((long)2L, (long)underTest.getPlugins().size());
        underTest.executeBeforeSetUpCallback((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback1, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback2, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
    }

    @Test
    public void testAddAfterSetUpCallback() throws Exception {
        ContextPlugins underTest = new ContextPlugins();
        underTest.addAfterSetUpCallback(new ContextCallback[]{this.callback1, this.callback2, null});
        Assert.assertEquals((long)2L, (long)underTest.getPlugins().size());
        underTest.executeAfterSetUpCallback((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback1, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback2, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
    }

    @Test
    public void testAddBeforeTearDownCallback() throws Exception {
        ContextPlugins underTest = new ContextPlugins();
        underTest.addBeforeTearDownCallback(new ContextCallback[]{this.callback1, this.callback2, null});
        Assert.assertEquals((long)2L, (long)underTest.getPlugins().size());
        underTest.executeBeforeTearDownCallback((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback1, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback2, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
    }

    @Test
    public void testAddAfterTearDownCallback() throws Exception {
        ContextPlugins underTest = new ContextPlugins();
        underTest.addAfterTearDownCallback(new ContextCallback[]{this.callback1, this.callback2, null});
        Assert.assertEquals((long)2L, (long)underTest.getPlugins().size());
        underTest.executeAfterTearDownCallback((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback1, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
        ((ContextCallback)Mockito.verify((Object)this.callback2, (VerificationMode)Mockito.times((int)1))).execute((OsgiContextImpl)this.context);
    }
}

