/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post;

import org.apache.sling.servlets.post.ModificationType;

public class Modification {
    private final ModificationType type;
    private final String source;
    private final String destination;

    public Modification(ModificationType type, String source, String destination) {
        this.type = type;
        this.source = source;
        this.destination = destination;
    }

    public ModificationType getType() {
        return this.type;
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.destination;
    }

    public static Modification onModified(String path) {
        return Modification.onChange(ModificationType.MODIFY, path);
    }

    public static Modification onCreated(String path) {
        return Modification.onChange(ModificationType.CREATE, path);
    }

    public static Modification onDeleted(String path) {
        return Modification.onChange(ModificationType.DELETE, path);
    }

    public static Modification onMoved(String srcPath, String dstPath) {
        return Modification.onChange(ModificationType.MOVE, srcPath, dstPath);
    }

    public static Modification onCopied(String srcPath, String dstPath) {
        return Modification.onChange(ModificationType.COPY, srcPath, dstPath);
    }

    public static Modification onOrder(String orderedPath, String beforeSibling) {
        return Modification.onChange(ModificationType.ORDER, orderedPath, beforeSibling);
    }

    protected static Modification onChange(ModificationType type, String source) {
        return Modification.onChange(type, source, null);
    }

    protected static Modification onChange(ModificationType type, String source, String dest) {
        return new Modification(type, source, dest);
    }

    public static Modification onCheckin(String path) {
        return Modification.onChange(ModificationType.CHECKIN, path, null);
    }

    public static Modification onCheckout(String path) {
        return Modification.onChange(ModificationType.CHECKOUT, path, null);
    }

    public static Modification onRestore(String path, String version) {
        return Modification.onChange(ModificationType.RESTORE, path, version);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Modification[type=").append((Object)this.type).append(", source=").append(this.source);
        if (this.destination != null) {
            builder.append(", dest=").append(this.destination);
        }
        builder.append("]");
        return builder.toString();
    }
}

