/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.compiled;

import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.java.compiler.ClassInfo;
import org.apache.sling.scripting.sightly.java.compiler.JavaEscapeUtils;

public class SourceIdentifier
implements ClassInfo {
    private SightlyEngineConfiguration engineConfiguration;
    private String scriptName;
    private String simpleClassName;
    private String packageName;
    private String fullyQualifiedClassName;

    SourceIdentifier(SightlyEngineConfiguration engineConfiguration, String resourcePath) {
        this.engineConfiguration = engineConfiguration;
        this.scriptName = resourcePath;
    }

    public String getSimpleClassName() {
        if (this.simpleClassName == null) {
            int lastSlashIndex = this.scriptName.lastIndexOf("/");
            String processingScriptName = this.scriptName;
            if (this.scriptName.endsWith(".java")) {
                processingScriptName = this.scriptName.substring(0, this.scriptName.length() - 5);
            }
            this.simpleClassName = lastSlashIndex != -1 ? JavaEscapeUtils.makeJavaPackage((String)processingScriptName.substring(lastSlashIndex)) : JavaEscapeUtils.makeJavaPackage((String)processingScriptName);
        }
        return this.simpleClassName;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            int lastSlashIndex = this.scriptName.lastIndexOf("/");
            String processingScriptName = this.scriptName;
            boolean javaFile = this.scriptName.endsWith(".java");
            if (javaFile) {
                processingScriptName = this.scriptName.substring(0, this.scriptName.length() - 5).replaceAll("-", "_");
            }
            this.packageName = lastSlashIndex != -1 ? JavaEscapeUtils.makeJavaPackage((String)processingScriptName.substring(0, lastSlashIndex)) : JavaEscapeUtils.makeJavaPackage((String)processingScriptName);
            if (!javaFile) {
                this.packageName = this.engineConfiguration.getBundleSymbolicName() + "." + this.packageName;
            }
        }
        return this.packageName;
    }

    public String getFullyQualifiedClassName() {
        if (this.fullyQualifiedClassName == null) {
            this.fullyQualifiedClassName = this.getPackageName() + "." + this.getSimpleClassName();
        }
        return this.fullyQualifiedClassName;
    }
}

