/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.compiler.source;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class JavaEscapeHelper {
    private static final Set<String> javaKeywords = new HashSet<String>();
    private static final Set<String> literals = new HashSet<String>();
    private static final Set<String> specialIdentifiers = new HashSet<String>();
    private static final Pattern ESCAPED_CHAR_PATTERN = Pattern.compile("(__[0-9a-f]{4}__)");

    private JavaEscapeHelper() {
    }

    @NotNull
    public static String getJavaIdentifier(@NotNull String identifier) {
        StringBuilder modifiedIdentifier = new StringBuilder();
        char[] identifierChars = new char[identifier.length()];
        identifier.getChars(0, identifier.length(), identifierChars, 0);
        for (int i = 0; i < identifierChars.length; ++i) {
            char ch = identifierChars[i];
            if (i == 0 && !Character.isJavaIdentifierStart(ch)) {
                modifiedIdentifier.append(JavaEscapeHelper.escapeChar(ch));
                continue;
            }
            if (!Character.isJavaIdentifierPart(ch)) {
                modifiedIdentifier.append(JavaEscapeHelper.escapeChar(ch));
                continue;
            }
            modifiedIdentifier.append(ch);
        }
        String currentIdentifier = modifiedIdentifier.toString();
        if (JavaEscapeHelper.isJavaKeyword(currentIdentifier) || JavaEscapeHelper.isJavaLiteral(currentIdentifier) || JavaEscapeHelper.isSpecialIdentifier(currentIdentifier)) {
            return JavaEscapeHelper.escapeChar(currentIdentifier.charAt(0)) + currentIdentifier.substring(1);
        }
        return currentIdentifier;
    }

    @NotNull
    public static String escapeChar(char ch) {
        return String.format("__%04x__", ch);
    }

    public static char unescape(@NotNull String escapeSequence) {
        Matcher matcher = ESCAPED_CHAR_PATTERN.matcher(escapeSequence);
        if (matcher.matches() && matcher.groupCount() == 1) {
            String toProcess = escapeSequence.replace("__", "");
            return (char)Integer.parseInt(toProcess, 16);
        }
        throw new IllegalArgumentException(String.format("String '%s' does not match pattern %s.", escapeSequence, ESCAPED_CHAR_PATTERN.pattern()));
    }

    @NotNull
    public static String unescapeAll(@NotNull String input) {
        String unescaped = input;
        Matcher matcher = ESCAPED_CHAR_PATTERN.matcher(unescaped);
        while (matcher.find()) {
            String group = matcher.group();
            char unescapedChar = JavaEscapeHelper.unescape(group);
            unescaped = unescaped.replace(group, Character.toString(unescapedChar));
        }
        return unescaped;
    }

    @NotNull
    public static String makeJavaPackage(@NotNull String path) {
        String[] classNameComponents = path.split("/|\\\\");
        StringBuilder legalClassNames = new StringBuilder();
        for (int i = 0; i < classNameComponents.length; ++i) {
            String classNameComponent = classNameComponents[i];
            if (classNameComponent.isEmpty()) continue;
            legalClassNames.append(JavaEscapeHelper.getJavaIdentifier(classNameComponent));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    public static boolean isJavaKeyword(@NotNull String key) {
        return javaKeywords.contains(key);
    }

    public static boolean isJavaLiteral(@NotNull String key) {
        return literals.contains(key);
    }

    public static boolean isSpecialIdentifier(@NotNull String key) {
        return specialIdentifiers.contains(key);
    }

    static {
        javaKeywords.add("abstract");
        javaKeywords.add("assert");
        javaKeywords.add("boolean");
        javaKeywords.add("break");
        javaKeywords.add("byte");
        javaKeywords.add("case");
        javaKeywords.add("catch");
        javaKeywords.add("char");
        javaKeywords.add("class");
        javaKeywords.add("const");
        javaKeywords.add("continue");
        javaKeywords.add("default");
        javaKeywords.add("do");
        javaKeywords.add("double");
        javaKeywords.add("else");
        javaKeywords.add("enum");
        javaKeywords.add("extends");
        javaKeywords.add("final");
        javaKeywords.add("finally");
        javaKeywords.add("float");
        javaKeywords.add("for");
        javaKeywords.add("goto");
        javaKeywords.add("if");
        javaKeywords.add("implements");
        javaKeywords.add("import");
        javaKeywords.add("instanceof");
        javaKeywords.add("int");
        javaKeywords.add("interface");
        javaKeywords.add("long");
        javaKeywords.add("native");
        javaKeywords.add("new");
        javaKeywords.add("package");
        javaKeywords.add("private");
        javaKeywords.add("protected");
        javaKeywords.add("public");
        javaKeywords.add("return");
        javaKeywords.add("short");
        javaKeywords.add("static");
        javaKeywords.add("strictfp");
        javaKeywords.add("super");
        javaKeywords.add("switch");
        javaKeywords.add("synchronized");
        javaKeywords.add("this");
        javaKeywords.add("throw");
        javaKeywords.add("throws");
        javaKeywords.add("transient");
        javaKeywords.add("try");
        javaKeywords.add("void");
        javaKeywords.add("volatile");
        javaKeywords.add("while");
        javaKeywords.add("_");
        literals.add("true");
        literals.add("false");
        literals.add("null");
        specialIdentifiers.add("var");
    }
}

