/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.integration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.commons.testing.integration.HttpTestBase;
import org.apache.sling.commons.testing.integration.SlingIntegrationTestClient;

public class HttpTestNode {
    public final String testText;
    public final String nodeUrl;
    public final String resourceType;
    public final String scriptPath;
    private final SlingIntegrationTestClient testClient;

    public HttpTestNode(SlingIntegrationTestClient testClient, String parentPath, Map<String, String> properties) throws IOException {
        this.testClient = testClient;
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        this.testText = "This is a test node " + System.currentTimeMillis();
        properties.put("text", this.testText);
        this.nodeUrl = testClient.createNode(parentPath + "/", properties);
        this.resourceType = properties.get("sling:resourceType");
        this.scriptPath = "/apps/" + (this.resourceType == null ? "nt/unstructured" : this.resourceType);
        testClient.mkdirs(HttpTestBase.WEBDAV_BASE_URL, this.scriptPath);
    }

    public void delete() throws IOException {
        this.testClient.delete(this.nodeUrl);
    }
}

