/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.resource.impl.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceUtil;

public class PathParentExpandIterator
implements Iterator<String> {
    private final String rootPath;
    private final Iterator<String> paths;
    private final Queue<String> expandedPaths = new LinkedList<String>();

    public PathParentExpandIterator(String rootPath, Iterator<String> paths) {
        this.rootPath = rootPath;
        this.paths = paths;
    }

    @Override
    public boolean hasNext() {
        return this.paths.hasNext() || !this.expandedPaths.isEmpty();
    }

    @Override
    public String next() {
        if (this.expandedPaths.isEmpty()) {
            this.expandPaths(this.paths.next());
        }
        return this.expandedPaths.remove();
    }

    private void expandPaths(String path) {
        this.expandedPaths.add(path);
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath != null && !StringUtils.equals((CharSequence)parentPath, (CharSequence)this.rootPath)) {
            this.expandPaths(parentPath);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

