/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.management.impl.console;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import org.apache.sling.caconfig.management.impl.console.ServiceConfigurationPrinter;
import org.apache.sling.caconfig.spi.ConfigurationMetadataProvider;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class ConfigurationMetadataPrinter
implements ServiceConfigurationPrinter<ConfigurationMetadataProvider> {
    ConfigurationMetadataPrinter() {
    }

    @Override
    public void printConfiguration(PrintWriter pw, ServiceReference<ConfigurationMetadataProvider> serviceReference, BundleContext bundleContext) {
        ConfigurationMetadataProvider service = (ConfigurationMetadataProvider)bundleContext.getService(serviceReference);
        for (String configName : service.getConfigurationNames()) {
            ConfigurationMetadata metadata = service.getConfigurationMetadata(configName);
            if (metadata == null) continue;
            pw.print("    ");
            pw.print("- ");
            pw.println(metadata.getName());
            for (PropertyMetadata property : metadata.getPropertyMetadata().values()) {
                pw.print("        ");
                pw.print("- ");
                pw.print(property.getName());
                pw.print("(");
                pw.print(property.getType().getSimpleName());
                pw.print(")");
                if (property.getDefaultValue() != null) {
                    pw.print(" = ");
                    this.printValue(pw, property.getDefaultValue());
                }
                pw.println();
            }
        }
        bundleContext.ungetService(serviceReference);
    }

    private void printValue(PrintWriter pw, Object value) {
        if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                this.printValue(pw, Array.get(value, i));
            }
        } else {
            pw.print(value);
        }
    }
}

