/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.filter.Optimization;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.gdal.ErrorHandler;
import org.apache.sis.storage.gdal.FeatureIterator;
import org.apache.sis.storage.gdal.FieldAccessor;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStore;
import org.apache.sis.storage.gdal.OGR;
import org.apache.sis.storage.gdal.SpatialRef;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class FeatureLayer
extends AbstractFeatureSet {
    final GDALStore store;
    final MemorySegment handle;
    final DefaultFeatureType type;
    final FieldAccessor<?>[] fields;
    private final CoordinateReferenceSystem defaultCRS;
    final Geometries<?> library;
    FeatureIterator iterationInProgress;

    private FeatureLayer(GDALStore store, GDAL gdal, OGR ogr, MemorySegment handle) throws Throwable {
        super((Resource)store);
        int i;
        this.store = store;
        this.handle = handle;
        this.library = Geometries.factory((GeometryLibrary)store.library);
        FeatureTypeBuilder builder = new FeatureTypeBuilder();
        MemorySegment definition = ogr.getLayerDefinition.invokeExact(handle);
        int fieldCount = ogr.getFieldCount.invokeExact(definition);
        int geomCount = ogr.getGeomFieldCount.invokeExact(definition);
        Object[] fields = new FieldAccessor[1 + fieldCount + geomCount];
        HashMap<String, Integer> names = HashMap.newHashMap(fields.length);
        AttributeTypeBuilder[] props = new AttributeTypeBuilder[fields.length];
        fields[0] = FieldAccessor.Identifier.INSTANCE;
        props[0] = builder.addAttribute(fields[0].getJavaClass());
        int fieldIndex = 1;
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            FieldAccessor<?> field;
            fields[fieldIndex] = field = FieldAccessor.create(ogr, definition, i2);
            names.putIfAbsent(field.name(), fieldIndex);
            Class<?> element = field.getElementClass();
            props[fieldIndex++] = element != null ? builder.addAttribute(element).setMaximumOccurs(Integer.MAX_VALUE) : builder.addAttribute(field.getJavaClass());
        }
        CoordinateReferenceSystem defaultCRS = null;
        boolean generalize = FeatureLayer.forceGeometryCollection(store.getDriverName(gdal));
        boolean isFirstGeometry = true;
        for (i = 0; i < geomCount; ++i) {
            MemorySegment geomField = ogr.getGeomFieldDefinition.invokeExact(definition, i);
            if (GDAL.isNull(geomField)) continue;
            boolean setAsDefault = isFirstGeometry;
            int geomType = ogr.getGeomFieldType.invokeExact(geomField);
            Object name = GDAL.toString(ogr.getGeomFieldName.invokeExact(geomField));
            if (name == null || ((String)name).isBlank()) {
                name = setAsDefault ? "sis:geometry" : "geometry" + i;
                setAsDefault = false;
            } else {
                names.putIfAbsent((String)name, fieldIndex);
            }
            GeometryType gt = GeometryType.forBinaryType((int)geomType);
            if (generalize && (gt == GeometryType.POLYGON || gt == GeometryType.LINESTRING)) {
                gt = GeometryType.GEOMETRY;
            }
            Class geomClass = this.library.getGeometryClass(gt);
            CoordinateReferenceSystem crs = SpatialRef.parseCRS(store, gdal, ogr.getGeomFieldSpatialRef.invokeExact(geomField));
            AttributeTypeBuilder attribute = builder.addAttribute(geomClass).setCRS(crs);
            if (setAsDefault) {
                attribute.addRole(AttributeRole.DEFAULT_GEOMETRY);
            }
            props[fieldIndex] = attribute;
            fields[fieldIndex++] = new FieldAccessor.Geometry((String)name, i, geomClass, crs);
            if (!isFirstGeometry) continue;
            isFirstGeometry = false;
            defaultCRS = crs;
        }
        for (i = 0; i < fieldIndex; ++i) {
            String name = fields[i].name();
            Integer previous = names.putIfAbsent(name, i);
            if (previous == null || previous == i) continue;
            if (previous >= 0) {
                Integer value = ~previous.intValue();
                names.put(name, value);
                ((FieldAccessor)fields[previous]).rename(names, value);
            }
            ((FieldAccessor)fields[i]).rename(names, ~i);
        }
        for (i = 0; i < fieldIndex; ++i) {
            props[i].setName((CharSequence)fields[i].name());
        }
        String name = GDAL.toString(ogr.getLayerName.invokeExact(handle));
        this.type = builder.setName((CharSequence)name).build();
        this.fields = (FieldAccessor[])ArraysExt.resize((Object[])fields, (int)fieldIndex);
        this.defaultCRS = defaultCRS;
    }

    private static boolean forceGeometryCollection(String driverName) {
        if (driverName != null) {
            driverName = driverName.toLowerCase(Locale.US);
            return driverName.contains("shapefile");
        }
        return false;
    }

    static FeatureLayer[] listLayers(GDALStore parent, GDAL gdal) throws DataStoreException {
        MemorySegment dataset = parent.handle();
        try {
            int n = gdal.getLayerCount.invokeExact(dataset);
            FeatureLayer[] layers = new FeatureLayer[n];
            if (n != 0) {
                OGR ogr = gdal.ogr();
                for (int i = 0; i < n; ++i) {
                    MemorySegment layer = ogr.getLayer.invokeExact(dataset, i);
                    layers[i] = new FeatureLayer(parent, gdal, ogr, layer);
                }
            }
            return layers;
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
    }

    public final DefaultFeatureType getType() {
        return this.type;
    }

    final OGR OGR() throws DataStoreException {
        return this.store.getProvider().GDAL().ogr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        OGR ogr = this.OGR();
        try {
            MemorySegment extent;
            Arena arena;
            block18: {
                arena = Arena.ofConfined();
                try {
                    int error;
                    extent = arena.allocate(32L);
                    Object object = this.store;
                    synchronized (object) {
                        try {
                            error = ogr.getLayerExtent.invokeExact(this.handle, extent, 0);
                        }
                        catch (Throwable e) {
                            throw GDAL.propagate(e);
                        }
                    }
                    if (error == 0) break block18;
                    object = Optional.empty();
                    if (arena != null) {
                        arena.close();
                    }
                    return object;
                }
                catch (Throwable throwable) {
                    if (arena != null) {
                        try {
                            arena.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            GeneralEnvelope env = this.defaultCRS != null ? new GeneralEnvelope(this.defaultCRS) : new GeneralEnvelope(2);
            ValueLayout.OfDouble t = AddressLayout.JAVA_DOUBLE;
            env.setRange(0, extent.getAtIndex(t, 0L), extent.getAtIndex(t, 1L));
            env.setRange(1, extent.getAtIndex(t, 2L), extent.getAtIndex(t, 3L));
            Optional<GeneralEnvelope> optional = Optional.of(env);
            if (arena != null) {
                arena.close();
            }
            return optional;
        }
        finally {
            ErrorHandler.throwOnFailure(this.store, "getEnvelope");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        try {
            GDALStore gDALStore = this.store;
            synchronized (gDALStore) {
                FeatureIterator it = new FeatureIterator(this);
                Stream stream = (Stream)StreamSupport.stream(it, false).onClose(it);
                return stream;
            }
        }
        finally {
            ErrorHandler.throwOnFailure(this.store, "features");
        }
    }

    protected void prepareQueryOptimization(FeatureQuery query, Optimization optimizer) throws DataStoreException {
        optimizer.setFinalFeatureType(this.type);
    }

    final Errors errors() {
        return Errors.forLocale((Locale)this.store.getLocale());
    }

    public String toString() {
        return Strings.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{null, this.type.getName(), "crs", IdentifiedObjects.getDisplayName((IdentifiedObject)this.defaultCRS)});
    }
}

