/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.iso.content.DefaultSampleDimension;
import org.apache.sis.xml.bind.gco.GO_Real;
import org.apache.sis.xml.bind.gco.UnitAdapter;
import org.apache.sis.xml.bind.gmi.MI_Band;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.BandDefinition;
import org.opengis.metadata.content.PolarizationOrientation;
import org.opengis.metadata.content.TransferFunctionType;

@XmlType(name="MD_Band_Type", propOrder={"boundMax", "boundMin", "boundUnits", "peakResponse", "toneGradation", "bandBoundaryDefinition", "nominalSpatialResolution", "transferFunctionType", "transmittedPolarization", "detectedPolarization"})
@XmlRootElement(name="MD_Band")
@XmlSeeAlso(value={MI_Band.class})
public class DefaultBand
extends DefaultSampleDimension
implements Band {
    private static final long serialVersionUID = -2474871120376144737L;
    private Double boundMin;
    private Double boundMax;
    private Unit<Length> boundUnits;
    private BandDefinition bandBoundaryDefinition;
    private Double peakResponse;
    private Integer toneGradation;
    private PolarizationOrientation transmittedPolarization;
    private PolarizationOrientation detectedPolarization;

    public DefaultBand() {
    }

    public DefaultBand(Band object) {
        super(object);
        if (object != null) {
            if (object instanceof DefaultBand) {
                DefaultBand c = (DefaultBand)object;
                this.boundMin = c.getBoundMin();
                this.boundMax = c.getBoundMax();
                this.boundUnits = c.getBoundUnits();
            }
            this.peakResponse = object.getPeakResponse();
            this.toneGradation = object.getToneGradation();
            this.bandBoundaryDefinition = object.getBandBoundaryDefinition();
            this.transmittedPolarization = object.getTransmittedPolarization();
            this.detectedPolarization = object.getDetectedPolarization();
        }
    }

    public static DefaultBand castOrCopy(Band object) {
        if (object == null || object instanceof DefaultBand) {
            return (DefaultBand)object;
        }
        return new DefaultBand(object);
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="boundMin")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @UML(identifier="boundMin", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getBoundMin() {
        return this.boundMin;
    }

    public void setBoundMin(Double newValue) {
        this.checkWritePermission(this.boundMin);
        if (ImplementationHelper.ensurePositive(DefaultBand.class, "boundMin", false, newValue)) {
            this.boundMin = newValue;
        }
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="boundMax")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @UML(identifier="boundMax", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getBoundMax() {
        return this.boundMax;
    }

    public void setBoundMax(Double newValue) {
        this.checkWritePermission(this.boundMax);
        if (ImplementationHelper.ensurePositive(DefaultBand.class, "boundMax", false, newValue)) {
            this.boundMax = newValue;
        }
    }

    @XmlElement(name="boundUnits")
    @XmlJavaTypeAdapter(value=UnitAdapter.Since2014.class)
    @UML(identifier="boundUnits", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Unit<Length> getBoundUnits() {
        return this.boundUnits;
    }

    public void setBoundUnits(Unit<Length> newValue) {
        this.checkWritePermission(this.boundUnits);
        this.boundUnits = newValue;
    }

    @XmlElement(name="bandBoundaryDefinition")
    public BandDefinition getBandBoundaryDefinition() {
        return this.bandBoundaryDefinition;
    }

    public void setBandBoundaryDefinition(BandDefinition newValue) {
        this.checkWritePermission(this.bandBoundaryDefinition);
        this.bandBoundaryDefinition = newValue;
    }

    public Unit<Length> getUnits() {
        Unit<?> units = super.getUnits();
        return units != null ? units.asType(Length.class) : null;
    }

    @Override
    public void setUnits(Unit<?> newValue) {
        super.setUnits(newValue != null ? newValue.asType(Length.class) : null);
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="peakResponse")
    public Double getPeakResponse() {
        return this.peakResponse;
    }

    public void setPeakResponse(Double newValue) {
        this.checkWritePermission(this.peakResponse);
        if (ImplementationHelper.ensurePositive(DefaultBand.class, "peakResponse", false, newValue)) {
            this.peakResponse = newValue;
        }
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="toneGradation")
    public Integer getToneGradation() {
        return this.toneGradation;
    }

    public void setToneGradation(Integer newValue) {
        this.checkWritePermission(this.toneGradation);
        if (ImplementationHelper.ensurePositive(DefaultBand.class, "toneGradation", false, newValue)) {
            this.toneGradation = newValue;
        }
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlElement(name="nominalSpatialResolution")
    public Double getNominalSpatialResolution() {
        return super.getNominalSpatialResolution();
    }

    @Override
    public void setNominalSpatialResolution(Double newValue) {
        super.setNominalSpatialResolution(newValue);
    }

    @Override
    @XmlElement(name="transferFunctionType")
    public TransferFunctionType getTransferFunctionType() {
        return super.getTransferFunctionType();
    }

    @Override
    public void setTransferFunctionType(TransferFunctionType newValue) {
        super.setTransferFunctionType(newValue);
    }

    @XmlElement(name="transmittedPolarisation")
    public PolarizationOrientation getTransmittedPolarization() {
        return this.transmittedPolarization;
    }

    public void setTransmittedPolarization(PolarizationOrientation newValue) {
        this.checkWritePermission(this.transmittedPolarization);
        this.transmittedPolarization = newValue;
    }

    @XmlElement(name="detectedPolarisation")
    public PolarizationOrientation getDetectedPolarization() {
        return this.detectedPolarization;
    }

    public void setDetectedPolarization(PolarizationOrientation newValue) {
        this.checkWritePermission(this.detectedPolarization);
        this.detectedPolarization = newValue;
    }
}

