/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import org.apache.sis.system.DaemonThread;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.logging.Logging;

public final class Threads {
    public static final ThreadGroup SIS;
    static final ThreadGroup DAEMONS;
    static DaemonThread lastCreatedDaemon;

    private Threads() {
    }

    static synchronized void shutdown(long stopWaitingAt) throws InterruptedException {
        DaemonThread.killAll(lastCreatedDaemon, stopWaitingAt);
    }

    static {
        ThreadGroup parent = Thread.currentThread().getThreadGroup();
        try {
            ThreadGroup candidate;
            while ((candidate = parent.getParent()) != null) {
                parent = candidate;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SIS = new ThreadGroup(parent, "Apache SIS");
        DAEMONS = new ThreadGroup(SIS, "Daemons"){

            @Override
            public void uncaughtException(Thread thread, Throwable exception) {
                Logging.severeException(SystemListener.LOGGER, thread.getClass(), "run", exception);
            }
        };
    }
}

