/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.tiling;

import java.nio.file.Path;
import java.util.Optional;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.tiling.TileStatus;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.opengis.metadata.Metadata;

public interface Tile {
    public long[] getIndices();

    default public Optional<Metadata> getMetadata() {
        return Optional.empty();
    }

    public TileStatus getStatus();

    public Resource getResource() throws DataStoreException;

    default public Optional<Path> getContentPath() throws DataStoreException {
        return this.getResource().getFileSet().map(fs -> (Path)CollectionsExt.first(fs.getPaths()));
    }
}

