/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.storage.aggregate.CoverageAggregator;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.GroupByCRS;
import org.apache.sis.storage.aggregate.GroupByTransform;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class GroupBySample
extends Group<GroupByCRS<GroupByTransform>> {
    private final List<SampleDimension> ranges;

    GroupBySample(CoverageAggregator parent, List<SampleDimension> ranges) {
        super(parent);
        this.ranges = List.copyOf(ranges);
    }

    @Override
    final String createName(Locale locale) {
        StringJoiner name = new StringJoiner(", ");
        for (SampleDimension range : this.ranges) {
            name.add(range.getName().toInternationalString().toString(locale));
        }
        return name.toString();
    }

    final boolean accepts(List<SampleDimension> candidate) {
        return this.ranges.equals(candidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final GroupByCRS<GroupByTransform> getOrAdd(CoordinateReferenceSystem crs) {
        List list = this.members;
        synchronized (list) {
            GroupByCRS<GroupByTransform> group;
            int i = this.members.size();
            while (--i >= 0) {
                group = (GroupByCRS<GroupByTransform>)this.members.get(i);
                if (!group.accepts(crs)) continue;
                return group;
            }
            group = new GroupByCRS<GroupByTransform>(this, crs);
            this.members.add(group);
            return group;
        }
    }

    final boolean contains(GridSlice slice) {
        for (GroupByCRS byCRS : this.members) {
            for (GroupByTransform group : byCRS.members) {
                if (!group.members.contains(slice)) continue;
                return true;
            }
        }
        return false;
    }

    final void createComponents(GroupAggregate destination) {
        destination.sampleDimensions = this.ranges;
        destination.fillWithChildAggregates(this, (byCRS, child) -> {
            child.fillWithCoverageComponents(byCRS.members, this.ranges);
            child.sampleDimensions = this.ranges;
        });
    }
}

