/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.TokenVisitor;
import org.apache.royale.linter.problems.ILinterProblem;

public class MissingSemicolonRule
extends LinterRule {
    @Override
    public Map<Integer, TokenVisitor> getTokenVisitors() {
        HashMap<Integer, TokenVisitor> result = new HashMap<Integer, TokenVisitor>();
        result.put(55, (token, tokenQuery, problems) -> this.checkSemicolon(token, tokenQuery, problems));
        return result;
    }

    private void checkSemicolon(IASToken semicolon, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        if (!semicolon.isImplicit()) {
            return;
        }
        problems.add(new MissingSemicolonLinterProblem(semicolon));
    }

    public static class MissingSemicolonLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Semicolon is required";

        public MissingSemicolonLinterProblem(IASToken token) {
            super(token);
        }
    }
}

