/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.parsing.SourceFragment;
import org.apache.royale.compiler.internal.parsing.SourceFragmentsReader;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.parsing.as.StreamingASTokenizer;
import org.apache.royale.compiler.internal.parsing.as.StreamingTokenBuffer;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLImplementsNode;

class MXMLImplementsNode
extends MXMLNodeBase
implements IMXMLImplementsNode {
    private static final IIdentifierNode[] NO_INTERFACE_NODES = new IIdentifierNode[0];
    private static final String STRING_TO_PREPEND = "internal class C implements ";
    private static final String STRING_TO_APPEND = " {}";
    private IIdentifierNode[] interfaceNodes = NO_INTERFACE_NODES;

    MXMLImplementsNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLImplementsID;
    }

    @Override
    public String getName() {
        return "implements";
    }

    @Override
    public int getChildCount() {
        return this.interfaceNodes.length;
    }

    @Override
    public IASNode getChild(int i) {
        return this.interfaceNodes[i];
    }

    @Override
    public IIdentifierNode[] getInterfaceNodes() {
        return this.interfaceNodes;
    }

    protected void initializeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        this.setLocation(attribute);
        this.adjustOffsets(builder);
        Workspace workspace = builder.getWorkspace();
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] valueFragments = attribute.getValueFragments(problems);
        int n = valueFragments.length;
        ISourceFragment[] fragments = new ISourceFragment[n + 2];
        fragments[0] = new SourceFragment(STRING_TO_PREPEND, STRING_TO_PREPEND, 0, 0, 0);
        for (int i = 0; i < n; ++i) {
            fragments[i + 1] = valueFragments[i];
        }
        fragments[n + 1] = new SourceFragment(STRING_TO_APPEND, STRING_TO_APPEND, 0, 0, 0);
        SourceFragmentsReader reader = new SourceFragmentsReader(attribute.getSourcePath(), fragments);
        StreamingASTokenizer tokenizer = new StreamingASTokenizer();
        tokenizer.setReader(reader);
        StreamingTokenBuffer buffer = new StreamingTokenBuffer(tokenizer);
        ASParser parser = new ASParser(workspace, buffer);
        FileNode fileNode = new FileNode(builder.getFileSpecificationGetter());
        parser.parseFile(fileNode, (EnumSet)EnumSet.of(PostProcessStep.CALCULATE_OFFSETS));
        problems.addAll(tokenizer.getTokenizationProblems());
        problems.addAll(parser.getSyntaxProblems());
        ArrayList<IIdentifierNode> interfaceNodeList = new ArrayList<IIdentifierNode>();
        if (fileNode.getChildCount() == 1 && fileNode.getChild(0) instanceof IClassNode) {
            IClassNode classNode = (IClassNode)fileNode.getChild(0);
            for (IExpressionNode interfaceNode : classNode.getImplementedInterfaceNodes()) {
                if (!(interfaceNode instanceof IIdentifierNode)) continue;
                interfaceNodeList.add((IIdentifierNode)interfaceNode);
                ((NodeBase)((Object)interfaceNode)).setParent(this);
            }
        }
        this.interfaceNodes = interfaceNodeList.toArray(new IIdentifierNode[0]);
    }
}

