/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.compiler.asdoc.IASDocComment;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.common.NodeReference;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IDocumentableDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.IScopedDefinition;
import org.apache.royale.compiler.definitions.metadata.IDeprecationInfo;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.INamespaceResolvedReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.common.Counter;
import org.apache.royale.compiler.internal.definitions.AppliedVectorDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.definitions.metadata.DeprecationInfo;
import org.apache.royale.compiler.internal.definitions.metadata.MetaTag;
import org.apache.royale.compiler.internal.parsing.as.OffsetLookup;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.ASScopeBase;
import org.apache.royale.compiler.internal.scopes.SWCFileScopeProvider;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDocumentableDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.units.ICompilationUnit;

public abstract class DefinitionBase
implements IDocumentableDefinition,
IDefinitionSet {
    protected static final short FLAG_CAST_FUNCTION = 1;
    protected static final short FLAG_CONSTRUCTOR = 2;
    protected static final short FLAG_DYNAMIC = 4;
    protected static final short FLAG_FINAL = 8;
    protected static final short FLAG_IMPLICIT = 16;
    protected static final short FLAG_NATIVE = 32;
    protected static final short FLAG_OVERRIDE = 64;
    protected static final short FLAG_REST = 128;
    protected static final short FLAG_STATIC = 256;
    protected static final short FLAG_DEFAULT = 512;
    protected static final short FLAG_CONTINGENT = 1024;
    protected static final short FLAG_GENERATED_EMBED_CLASS = 2048;
    protected static final short FLAG_HAS_INIT = 4096;
    protected static final short FLAG_DEPRECATED = 8192;
    protected static final short FLAG_DECLARED_IN_CONTROL_FLOW = 16384;
    private static boolean performanceCachingEnabled = false;
    private IASScope containingScope;
    protected short flags;
    private INamespaceResolvedReference namespaceReference;
    private final String storageName;
    private IReference typeReference;
    private IMetaTag[] metaTags = singletonEmptyMetaTags;
    protected static final IMetaTag[] singletonEmptyMetaTags = new IMetaTag[0];
    protected NodeReference nodeRef = NodeReference.noReference;
    private int absoluteNameStart = 0;
    private int absoluteNameEnd = 0;
    private IDefinition parentDef = null;
    private boolean abstractFlag = false;

    public static boolean getPerformanceCachingEnabled() {
        return performanceCachingEnabled;
    }

    public static void setPerformanceCachingEnabled(boolean enable) {
        performanceCachingEnabled = enable;
    }

    public DefinitionBase(String name) {
        assert (name != null);
        this.storageName = this.toStorageName(name);
    }

    public void setLocation(IMXMLTagData tag) {
        this.nodeRef = new NodeReference(tag.getSource(), tag.getAbsoluteStart());
    }

    public void setNode(IDefinitionNode node) {
        if (node == null) {
            this.nodeRef = NodeReference.noReference;
            this.absoluteNameStart = -1;
            this.absoluteNameEnd = -1;
        } else {
            this.nodeRef = new NodeReference(node);
            IExpressionNode nameNode = node.getNameExpressionNode();
            if (nameNode != null) {
                this.absoluteNameStart = nameNode.getAbsoluteStart();
                this.absoluteNameEnd = nameNode.getAbsoluteEnd();
            } else {
                this.absoluteNameStart = -1;
                this.absoluteNameEnd = -1;
            }
        }
    }

    public void setNameLocation(int absoluteNameStart, int absoluteNameEnd) {
        this.absoluteNameStart = absoluteNameStart;
        this.absoluteNameEnd = absoluteNameEnd;
    }

    @Override
    public IASScope getContainingScope() {
        return this.containingScope;
    }

    public void setContainingScope(IASScope scope) {
        this.containingScope = scope;
    }

    @Override
    public IDefinition getParent() {
        IScopedDefinition result;
        IASScope scope;
        if (DefinitionBase.getPerformanceCachingEnabled() && this.parentDef != null) {
            return this.parentDef;
        }
        for (scope = this.getContainingScope(); scope != null && scope.getDefinition() == null; scope = scope.getContainingScope()) {
        }
        IScopedDefinition iScopedDefinition = result = scope != null ? scope.getDefinition() : null;
        if (DefinitionBase.getPerformanceCachingEnabled()) {
            this.parentDef = result;
        }
        return result;
    }

    @Override
    public IDefinition getAncestorOfType(Class<? extends IDefinition> ancestorType) {
        IDefinition definition;
        for (definition = this.getParent(); definition != null && !ancestorType.isInstance(definition); definition = definition.getParent()) {
        }
        return definition;
    }

    protected String toStorageName(String name) {
        int i = name.lastIndexOf(46);
        return i == -1 ? name : name.substring(i + 1);
    }

    protected final String getStorageName() {
        return this.storageName;
    }

    public IFileSpecification getFileSpecification() {
        return this.nodeRef.getFileSpecification();
    }

    @Override
    public String getSourcePath() {
        IFileSpecification fileSpec = this.getFileSpecification();
        return fileSpec != null ? fileSpec.getPath() : null;
    }

    private OffsetLookup getOffsetLookup() {
        ASFileScope fileScope = this.getFileScope();
        if (fileScope == null) {
            return null;
        }
        return fileScope.getOffsetLookup();
    }

    @Override
    public int getStart() {
        if (this.nodeRef == null) {
            return -1;
        }
        int absoluteStart = this.nodeRef.getAbsoluteStart();
        if (absoluteStart == -1) {
            return -1;
        }
        OffsetLookup offsetLookup = this.getOffsetLookup();
        if (offsetLookup == null) {
            return absoluteStart;
        }
        return offsetLookup.getLocalOffset(absoluteStart);
    }

    @Override
    public int getEnd() {
        IDefinitionNode node = this.getNode();
        if (node == null) {
            return -1;
        }
        return node.getEnd();
    }

    @Override
    public int getLine() {
        IDefinitionNode node = this.getNode();
        if (node == null) {
            return -1;
        }
        return node.getLine();
    }

    @Override
    public int getColumn() {
        IDefinitionNode node = this.getNode();
        if (node == null) {
            return -1;
        }
        return node.getColumn();
    }

    @Override
    public int getEndLine() {
        IDefinitionNode node = this.getNode();
        if (node == null) {
            return -1;
        }
        return node.getEndLine();
    }

    @Override
    public int getEndColumn() {
        IDefinitionNode node = this.getNode();
        if (node == null) {
            return -1;
        }
        return node.getEndColumn();
    }

    @Override
    public int getAbsoluteStart() {
        if (this.nodeRef == null) {
            return -1;
        }
        return this.nodeRef.getAbsoluteStart();
    }

    @Override
    public int getAbsoluteEnd() {
        IDefinitionNode node = this.getNode();
        if (node == null) {
            return -1;
        }
        return node.getAbsoluteEnd();
    }

    private IExpressionNode getNameNode() {
        IDefinitionNode node = this.getNode();
        if (node == null) {
            return null;
        }
        return node.getNameExpressionNode();
    }

    @Override
    public int getNameStart() {
        if (this.absoluteNameStart == -1) {
            return -1;
        }
        OffsetLookup offsetLookup = this.getOffsetLookup();
        if (offsetLookup == null) {
            return this.absoluteNameStart;
        }
        return offsetLookup.getLocalOffset(this.absoluteNameStart);
    }

    @Override
    public int getNameEnd() {
        if (this.absoluteNameEnd == -1) {
            return -1;
        }
        OffsetLookup offsetLookup = this.getOffsetLookup();
        if (offsetLookup == null) {
            return this.absoluteNameEnd;
        }
        return offsetLookup.getLocalOffset(this.absoluteNameEnd);
    }

    @Override
    public int getNameLine() {
        IExpressionNode nameNode = this.getNameNode();
        if (nameNode == null) {
            return -1;
        }
        return nameNode.getLine();
    }

    @Override
    public int getNameColumn() {
        IExpressionNode nameNode = this.getNameNode();
        if (nameNode == null) {
            return -1;
        }
        return nameNode.getColumn();
    }

    @Override
    public String getContainingFilePath() {
        ASFileScope fileScope = this.getFileScope();
        if (fileScope == null) {
            return null;
        }
        return fileScope.getContainingPath();
    }

    @Override
    public String getContainingSourceFilePath(ICompilerProject project) {
        ASFileScope fileScope;
        if (this.nodeRef != NodeReference.noReference && (fileScope = this.getFileScope()) != null && fileScope.getOffsetLookup() != null) {
            return fileScope.getOffsetLookup().getFilename(this.getAbsoluteStart());
        }
        ASScope containingScope = (ASScope)this.getContainingScope();
        if (containingScope != null) {
            return containingScope.getContainingSourcePath(this.getQualifiedName(), project);
        }
        return null;
    }

    private static String namespaceReferenceToPackageName(INamespaceReference nsRef) {
        if (nsRef instanceof INamespaceDefinition.INamespaceWithPackageName) {
            return ((INamespaceDefinition.INamespaceWithPackageName)nsRef).getNamespacePackageName();
        }
        return null;
    }

    private static DefinitionBase getContainingToplevelDefinition(DefinitionBase definition) {
        ASScope currentContainingScope = definition.getContainingASScope();
        if (currentContainingScope == null) {
            return null;
        }
        DefinitionBase currentDefinition = definition;
        IScopedDefinition containingDefinition = currentContainingScope.getContainingDefinition();
        while (containingDefinition != null) {
            currentDefinition = (DefinitionBase)((Object)containingDefinition);
            currentContainingScope = currentDefinition.getContainingASScope();
            if (currentContainingScope == null) {
                return null;
            }
            containingDefinition = currentContainingScope.getContainingDefinition();
        }
        assert (currentDefinition != null);
        return currentDefinition;
    }

    @Override
    public String getPackageName() {
        assert (this.getContainingScope() != null) : "This method should not be called until we have a containing scope.!";
        DefinitionBase containingToplevelDefinition = DefinitionBase.getContainingToplevelDefinition(this);
        if (containingToplevelDefinition == null) {
            return "";
        }
        assert (!(containingToplevelDefinition instanceof FunctionDefinition) || !((FunctionDefinition)containingToplevelDefinition).isConstructor()) : "Constructors should always be contained by class definitions!";
        INamespaceReference toplevelDefinitionNSRef = containingToplevelDefinition.getNamespaceReference();
        assert (toplevelDefinitionNSRef != null);
        String packageNameFromNSRef = DefinitionBase.namespaceReferenceToPackageName(toplevelDefinitionNSRef);
        if (packageNameFromNSRef != null) {
            return packageNameFromNSRef;
        }
        assert (this.getBaseName().indexOf(46) == -1);
        return "";
    }

    @Override
    public String getBaseName() {
        return this.storageName;
    }

    @Override
    public String getQualifiedName() {
        String packageName;
        if (this.isTopLevelDefinition() && (packageName = this.getPackageName()) != null && !packageName.isEmpty()) {
            return packageName + "." + this.storageName;
        }
        return this.storageName;
    }

    public boolean isTopLevelDefinition() {
        return this.getParent() instanceof IPackageDefinition || this.getParent() == null;
    }

    @Override
    public boolean isDynamic() {
        return (this.flags & 4) != 0;
    }

    public void setDynamic() {
        this.flags = (short)(this.flags | 4);
    }

    @Override
    public boolean isFinal() {
        return (this.flags & 8) != 0;
    }

    public void setFinal() {
        this.flags = (short)(this.flags | 8);
    }

    @Override
    public boolean isNative() {
        return (this.flags & 0x20) != 0;
    }

    public void setNative() {
        this.flags = (short)(this.flags | 0x20);
    }

    @Override
    public boolean isOverride() {
        return (this.flags & 0x40) != 0;
    }

    public void setOverride() {
        this.flags = (short)(this.flags | 0x40);
    }

    public void unsetOverride() {
        if (this.isOverride()) {
            this.flags = (short)(this.flags - 64);
        }
    }

    @Override
    public boolean isStatic() {
        return (this.flags & 0x100) != 0;
    }

    public void setStatic() {
        this.flags = (short)(this.flags | 0x100);
    }

    @Override
    public boolean isAbstract() {
        return this.abstractFlag;
    }

    public void setAbstract() {
        this.abstractFlag = true;
    }

    @Override
    public boolean hasModifier(ASModifier modifier) {
        if (modifier == ASModifier.OVERRIDE) {
            return (this.flags & 0x40) != 0;
        }
        if (modifier == ASModifier.STATIC) {
            return (this.flags & 0x100) != 0;
        }
        if (modifier == ASModifier.FINAL) {
            return (this.flags & 8) != 0;
        }
        if (modifier == ASModifier.DYNAMIC) {
            return (this.flags & 4) != 0;
        }
        if (modifier == ASModifier.NATIVE) {
            return (this.flags & 0x20) != 0;
        }
        if (modifier == ASModifier.VIRTUAL) {
            return false;
        }
        if (modifier == ASModifier.ABSTRACT) {
            return this.abstractFlag;
        }
        assert (false) : "Unknown modifier: " + modifier;
        return false;
    }

    @Override
    public ModifiersSet getModifiers() {
        ModifiersSet result = new ModifiersSet();
        if ((this.flags & 0x40) != 0) {
            result.addModifier(ASModifier.OVERRIDE);
        }
        if ((this.flags & 0x100) != 0) {
            result.addModifier(ASModifier.STATIC);
        }
        if ((this.flags & 8) != 0) {
            result.addModifier(ASModifier.FINAL);
        }
        if ((this.flags & 4) != 0) {
            result.addModifier(ASModifier.DYNAMIC);
        }
        if ((this.flags & 0x20) != 0) {
            result.addModifier(ASModifier.NATIVE);
        }
        if (this.abstractFlag) {
            result.addModifier(ASModifier.ABSTRACT);
        }
        return result;
    }

    public void setModifier(ASModifier modifier) {
        if (modifier == ASModifier.OVERRIDE) {
            this.flags = (short)(this.flags | 0x40);
        } else if (modifier == ASModifier.STATIC) {
            this.flags = (short)(this.flags | 0x100);
        } else if (modifier == ASModifier.FINAL) {
            this.flags = (short)(this.flags | 8);
        } else if (modifier == ASModifier.DYNAMIC) {
            this.flags = (short)(this.flags | 4);
        } else if (modifier == ASModifier.NATIVE) {
            this.flags = (short)(this.flags | 0x20);
        } else if (modifier == ASModifier.ABSTRACT) {
            this.setAbstract();
        } else assert (false);
    }

    @Override
    public boolean isPublic() {
        return this.namespaceReference instanceof INamespaceDefinition.IPublicNamespaceDefinition;
    }

    @Override
    public boolean isPrivate() {
        return this.namespaceReference instanceof INamespaceDefinition.IPrivateNamespaceDefinition;
    }

    @Override
    public boolean isProtected() {
        return this.namespaceReference instanceof INamespaceDefinition.IProtectedNamespaceDefinition || this.namespaceReference instanceof INamespaceDefinition.IStaticProtectedNamespaceDefinition;
    }

    @Override
    public boolean isInternal() {
        return this.namespaceReference instanceof INamespaceDefinition.IInternalNamespaceDefinition;
    }

    @Override
    public boolean hasNamespace(INamespaceReference namespace, ICompilerProject project) {
        if (namespace.isLanguageNamespace() && this.namespaceReference.isLanguageNamespace()) {
            return namespace == this.namespaceReference;
        }
        INamespaceDefinition ns1 = namespace.resolveNamespaceReference(project);
        INamespaceDefinition ns2 = this.namespaceReference.resolveNamespaceReference(project);
        return ns1 != null && ns2 != null ? ns1.equals(ns2) : false;
    }

    @Override
    public INamespaceReference getNamespaceReference() {
        return this.namespaceReference;
    }

    public void setNamespaceReference(INamespaceReference value) {
        this.namespaceReference = (INamespaceResolvedReference)value;
        NamespaceDefinition.setContainingDefinitionOfReference(value, this);
    }

    public void setPublic() {
        this.setNamespaceReference(NamespaceDefinition.getPublicNamespaceDefinition());
    }

    public void setBindable() {
        MetaTag bindableMetaTag = new MetaTag(this, "Bindable", new IMetaTagAttribute[0]);
        this.addMetaTag(bindableMetaTag);
    }

    @Override
    public INamespaceDefinition resolveNamespace(ICompilerProject project) {
        return this.namespaceReference != null ? this.namespaceReference.resolveNamespaceReference(project) : null;
    }

    @Override
    public String getTypeAsDisplayString() {
        return this.typeReference != null ? this.typeReference.getDisplayString() : "";
    }

    @Override
    public IReference getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(IReference typeReference) {
        this.typeReference = typeReference;
    }

    protected DependencyType getTypeDependencyType() {
        return DependencyType.SIGNATURE;
    }

    @Override
    public TypeDefinitionBase resolveType(ICompilerProject project) {
        DependencyType dt = this.getTypeDependencyType();
        return this.resolveType(this.typeReference, project, dt);
    }

    @Override
    public boolean isImplicit() {
        return (this.flags & 0x10) != 0;
    }

    public void setImplicit() {
        this.flags = (short)(this.flags | 0x10);
    }

    @Override
    public IMetaTag[] getAllMetaTags() {
        return this.metaTags;
    }

    protected void addMetaTag(IMetaTag metaTag) {
        IMetaTag[] newMetaTags = new IMetaTag[this.metaTags.length + 1];
        System.arraycopy(this.metaTags, 0, newMetaTags, 0, this.metaTags.length);
        newMetaTags[this.metaTags.length] = metaTag;
        this.setMetaTags(newMetaTags);
    }

    public void setMetaTags(IMetaTag[] newMetaTags) {
        if (newMetaTags == null) {
            this.metaTags = singletonEmptyMetaTags;
        } else {
            for (IMetaTag metaTag : this.metaTags = newMetaTags) {
                String tagName = metaTag.getTagName();
                if (!tagName.equals("Deprecated")) continue;
                this.setDeprecated();
            }
        }
    }

    @Override
    public IMetaTag[] getMetaTagsByName(String name) {
        ArrayList<IMetaTag> list = new ArrayList<IMetaTag>();
        for (IMetaTag tag : this.metaTags) {
            if (!tag.getTagName().equals(name)) continue;
            list.add(tag);
        }
        return list.toArray(new IMetaTag[0]);
    }

    @Override
    public boolean hasMetaTagByName(String name) {
        return this.getMetaTagByName(name) != null;
    }

    @Override
    public IMetaTag getMetaTagByName(String name) {
        for (IMetaTag tag : this.metaTags) {
            if (!tag.getTagName().equals(name)) continue;
            return tag;
        }
        return null;
    }

    @Override
    public IASDocComment getExplicitSourceComment() {
        IDefinitionNode node = this.getNode();
        if (node instanceof IDocumentableDefinitionNode) {
            return ((IDocumentableDefinitionNode)node).getASDocComment();
        }
        return null;
    }

    @Override
    public boolean hasExplicitComment() {
        IDefinitionNode node = this.getNode();
        if (node instanceof IDocumentableDefinitionNode) {
            return ((IDocumentableDefinitionNode)node).hasExplicitComment();
        }
        return false;
    }

    public ASFileScope getFileScope() {
        ASScope s = this.getContainingASScope();
        if (s == null) {
            return null;
        }
        return s.getFileScope();
    }

    @Override
    public IDefinitionNode getNode() {
        if (this.nodeRef == NodeReference.noReference) {
            return null;
        }
        ASScope containingScope = this.getContainingASScope();
        if (containingScope == null) {
            return null;
        }
        ASFileScope fileScope = containingScope.getFileScope();
        if (fileScope == null) {
            return null;
        }
        IASNode node = this.nodeRef.getNode(fileScope.getWorkspace(), this.getContainingASScope());
        if (!(node instanceof IDefinitionNode)) {
            return null;
        }
        return (IDefinitionNode)node;
    }

    protected static TypeDefinitionBase resolveType(DefinitionBase context, String typeName, ICompilerProject project, DependencyType dt) {
        if (typeName == null) {
            return null;
        }
        CompilerProject compilerProject = (CompilerProject)project;
        ASScope containingScope = (ASScope)context.containingScope;
        if (containingScope != null) {
            int lastIndexOfDot = typeName.lastIndexOf(46);
            IDefinition foundDefinition = null;
            if (lastIndexOfDot != -1) {
                String unqualifiedName = typeName.substring(lastIndexOfDot + 1);
                String packageName = typeName.substring(0, lastIndexOfDot);
                INamespaceDefinition.ILanguageNamespaceDefinition packageNS = ((CompilerProject)project).getWorkspace().getPackageNamespaceDefinitionCache().get(packageName, false);
                foundDefinition = containingScope.findPropertyQualified((ICompilerProject)compilerProject, packageNS, unqualifiedName, dt, true);
            } else {
                foundDefinition = containingScope.findProperty((ICompilerProject)compilerProject, typeName, dt, true);
            }
            assert (foundDefinition == null || foundDefinition.isInProject(project));
            if (foundDefinition instanceof TypeDefinitionBase) {
                return (TypeDefinitionBase)foundDefinition;
            }
        }
        return null;
    }

    protected static TypeDefinitionBase resolveType(DefinitionBase context, IReference typeRef, ICompilerProject project, DependencyType dt) {
        if (typeRef == null) {
            return (TypeDefinitionBase)project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
        }
        IDefinition foundDefinition = typeRef.resolve(project, (ASScope)context.containingScope, dt, true);
        assert (foundDefinition == null || foundDefinition.isInProject(project));
        return foundDefinition instanceof TypeDefinitionBase ? (TypeDefinitionBase)foundDefinition : null;
    }

    protected TypeDefinitionBase resolveType(String typeName, ICompilerProject project, DependencyType dt) {
        return DefinitionBase.resolveType(this, typeName, project, dt);
    }

    public TypeDefinitionBase resolveType(IReference typeRef, ICompilerProject project, DependencyType dt) {
        return DefinitionBase.resolveType(this, typeRef, project, dt);
    }

    protected String getLocationString() {
        StringBuilder sb = new StringBuilder();
        int start = this.getStart();
        int end = this.getEnd();
        if (start != -1 && end != -1) {
            sb.append(start);
            sb.append('-');
            sb.append(end);
        }
        sb.append(' ');
        String path = this.getContainingFilePath();
        if (path != null) {
            sb.append(path);
        }
        return sb.toString();
    }

    public Name getMName(ICompilerProject project) {
        Name name = null;
        Namespace qual = null;
        if (this.namespaceReference != null) {
            qual = this.namespaceReference.resolveAETNamespace(project);
        } else {
            assert (false) : "All definitions should have a namespaceReference qualifier.";
            ASScope scope = this.getContainingASScope();
            if (scope != null) {
                qual = ((NamespaceDefinition)((Object)NamespaceDefinition.getDefaultNamespaceDefinition(scope))).getAETNamespace();
            }
        }
        if (qual != null) {
            name = new Name(7, new Nsset(qual), this.getBaseName());
        }
        return name;
    }

    protected final ASScope getContainingASScope() {
        IASScope s = this.getContainingScope();
        ASScope scope = s instanceof ASScope ? (ASScope)s : null;
        return scope;
    }

    protected String getNamespaceReferenceAsString() {
        INamespaceReference namespaceReference = this.getNamespaceReference();
        return namespaceReference != null ? namespaceReference.toString() : "internal";
    }

    private boolean checkVectorMatch(DefinitionBase node) {
        IASScope thisScope = this.getContainingScope();
        IASScope nodeScope = node.getContainingScope();
        if (thisScope != null && nodeScope != null) {
            IScopedDefinition thisDef = thisScope.getDefinition();
            IScopedDefinition nodeDef = nodeScope.getDefinition();
            if (thisDef instanceof AppliedVectorDefinition && nodeDef instanceof AppliedVectorDefinition) {
                String thisElementQName = ((AppliedVectorDefinition)thisDef).getQualifiedName();
                String nodeElementQName = ((AppliedVectorDefinition)nodeDef).getQualifiedName();
                if (thisElementQName == null && nodeElementQName == null) {
                    return true;
                }
                if (thisElementQName == null) {
                    return false;
                }
                return thisElementQName.equals(nodeElementQName);
            }
        }
        return true;
    }

    public boolean matches(DefinitionBase node) {
        ASScope rightScope;
        if (node == null) {
            return false;
        }
        if (node.getClass() != this.getClass()) {
            return false;
        }
        if (node == this) {
            return true;
        }
        INamespaceReference namespace = this.getNamespaceReference();
        if (namespace == null && node.getNamespaceReference() != null) {
            return false;
        }
        if (namespace != null && namespace.getBaseName().compareTo(node.getNamespaceReference().getBaseName()) != 0) {
            return false;
        }
        if (node.getBaseName().compareTo(this.getBaseName()) != 0) {
            return false;
        }
        if (!this.checkVectorMatch(node)) {
            return false;
        }
        String packageName = node.getPackageName();
        String packageName2 = this.getPackageName();
        if (packageName == null && packageName2 != null) {
            return false;
        }
        if (packageName != null && packageName2 != null && packageName.compareTo(packageName2) != 0) {
            return false;
        }
        ASScope leftScope = node.getContainingASScope();
        if (leftScope != null) {
            leftScope = leftScope.getFileScope();
        }
        if ((rightScope = this.getContainingASScope()) != null) {
            rightScope = rightScope.getFileScope();
        }
        if (leftScope instanceof SWCFileScopeProvider.SWCFileScope || rightScope instanceof SWCFileScopeProvider.SWCFileScope) {
            return true;
        }
        if (leftScope instanceof ASFileScope && rightScope instanceof ASFileScope) {
            if (((ASFileScope)leftScope).getContainingPath().compareTo(((ASFileScope)rightScope).getContainingPath()) != 0) {
                return false;
            }
        } else {
            String nodePath = node.getContainingFilePath();
            String thisPath = this.getContainingFilePath();
            if (nodePath == null ? thisPath != null : nodePath.compareTo(thisPath) != 0) {
                return false;
            }
        }
        return node.getTypeAsDisplayString().compareTo(this.getTypeAsDisplayString()) == 0;
    }

    private boolean isBindableLocally() {
        return this.getMetaTagByName("Bindable") != null;
    }

    @Override
    public boolean isBindable() {
        boolean bindable = this.isBindableLocally();
        if (!bindable) {
            bindable = this.isClassBindable();
        }
        return bindable;
    }

    public boolean isClassBindable() {
        boolean classBindable = false;
        IDefinition containing = this.getParent();
        if (containing instanceof IClassDefinition && this.getNamespaceReference() == NamespaceDefinition.getPublicNamespaceDefinition()) {
            DefinitionBase containingBase = (DefinitionBase)containing;
            classBindable = containingBase.isBindableLocally();
        }
        return classBindable;
    }

    @Override
    public List<String> getBindableEventNames() {
        HashSet<String> eventNames = new HashSet<String>(this.getBindableEventNamesLocally());
        IDefinition containing = this.getParent();
        if (containing instanceof IClassDefinition && this.getNamespaceReference() == NamespaceDefinition.getPublicNamespaceDefinition()) {
            DefinitionBase containingBase = (DefinitionBase)containing;
            eventNames.addAll(containingBase.getBindableEventNamesLocally());
        }
        return new ArrayList<String>(eventNames);
    }

    private List<String> getBindableEventNamesLocally() {
        IMetaTag[] bindableTags = this.getMetaTagsByName("Bindable");
        if (bindableTags != null) {
            ArrayList<String> events = new ArrayList<String>();
            for (IMetaTag bindableTag : bindableTags) {
                String eventName = bindableTag.getAttributeValue("event");
                if (eventName == null && bindableTag.getAllAttributes().length == 1) {
                    Boolean isStyle = false;
                    eventName = bindableTag.getAllAttributes()[0].getKey();
                    if (eventName != null && eventName.equals("style")) {
                        isStyle = true;
                    }
                    eventName = bindableTag.getAllAttributes()[0].getValue();
                    if (isStyle.booleanValue() && eventName.equals("true")) {
                        eventName = "isStyle";
                    }
                }
                if (eventName == null) continue;
                events.add(eventName);
            }
            return events;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isBindableStyle() {
        IMetaTag[] bindableTags = this.getMetaTagsByName("Bindable");
        if (bindableTags != null) {
            for (IMetaTag bindableTag : bindableTags) {
                String style = bindableTag.getAttributeValue("style");
                if (style == null || !"true".equals(style)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isContingent() {
        return (this.flags & 0x400) != 0;
    }

    protected void setContingent() {
        this.flags = (short)(this.flags | 0x400);
    }

    @Override
    public boolean isGeneratedEmbedClass() {
        return (this.flags & 0x800) != 0;
    }

    public void setGeneratedEmbedClass() {
        this.flags = (short)(this.flags | 0x800);
    }

    @Override
    public boolean isContingentNeeded(ICompilerProject project) {
        return ((ASScopeBase)this.getContainingScope()).isContingentDefinitionNeeded(project, this);
    }

    protected IMetaTag getSkinPart() {
        return this.getMetaTagByName("SkinPart");
    }

    protected boolean isRequiredSkinPart(IMetaTag skinPart) {
        String isRequired = skinPart.getAttributeValue("required");
        if (isRequired == null) {
            return false;
        }
        return isRequired.equals("true");
    }

    public String getArrayElementType(ICompilerProject project) {
        if (this.getTypeAsDisplayString().equals("Array") || "Array".equals(this.getInstanceType(project))) {
            return this.getPropertyMetaTagValue((RoyaleProject)project, "ArrayElementType");
        }
        return null;
    }

    public String getInstanceType(ICompilerProject project) {
        if (this.getTypeAsDisplayString().equals(((RoyaleProject)project).getDeferredInstanceInterface())) {
            return this.getPropertyMetaTagValue((RoyaleProject)project, "InstanceType");
        }
        return null;
    }

    public String getPercentProxy(ICompilerProject project) {
        IMetaTag metaTag = this.getPropertyMetaTag((RoyaleProject)project, "PercentProxy");
        return metaTag != null ? metaTag.getValue() : null;
    }

    public boolean hasRichTextContent(ICompilerProject project) {
        IMetaTag metaTag = this.getPropertyMetaTag((RoyaleProject)project, "RichTextContent");
        return metaTag != null;
    }

    public boolean hasCollapseWhiteSpace(ICompilerProject project) {
        IMetaTag metaTag = this.getPropertyMetaTag((RoyaleProject)project, "CollapseWhiteSpace");
        return metaTag != null;
    }

    public boolean isColor(ICompilerProject project) {
        IMetaTag metaTag = this.getPropertyMetaTag((RoyaleProject)project, "Inspectable");
        if (metaTag == null) {
            return false;
        }
        String format = metaTag.getAttributeValue("format");
        return format.equals("Color");
    }

    private IMetaTag getPropertyMetaTag(RoyaleProject project, String metadataName) {
        IAccessorDefinition correspondingAccessor;
        IMetaTag metaTag = this.getMetaTagByName(metadataName);
        if (metaTag == null && this instanceof IAccessorDefinition && (correspondingAccessor = ((IAccessorDefinition)((Object)this)).resolveCorrespondingAccessor(project)) != null) {
            metaTag = correspondingAccessor.getMetaTagByName(metadataName);
        }
        return metaTag;
    }

    private String getPropertyMetaTagValue(RoyaleProject project, String metadataName) {
        IMetaTag metaTag = this.getPropertyMetaTag(project, metadataName);
        return metaTag != null ? metaTag.getValue() : null;
    }

    protected boolean inPackageNamespace() {
        INamespaceReference nsRef = this.getNamespaceReference();
        assert (nsRef != null) : "All definitions should have a namespaceReference reference!";
        return nsRef.isPublicOrInternalNamespace();
    }

    @Override
    public boolean isDeprecated() {
        return (this.flags & 0x2000) != 0;
    }

    private void setDeprecated() {
        this.flags = (short)(this.flags | 0x2000);
    }

    @Override
    public IDeprecationInfo getDeprecationInfo() {
        for (IMetaTag metaTag : this.metaTags) {
            if (!metaTag.getTagName().equals("Deprecated")) continue;
            String replacement = metaTag.getAttributeValue("replacement");
            String since = metaTag.getAttributeValue("since");
            String message = metaTag.getAttributeValue("message");
            return new DeprecationInfo(replacement, since, message);
        }
        return null;
    }

    public boolean verify() {
        assert (this.getBaseName() != null) : "Definition has null name";
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.buildString(sb, false);
        return sb.toString();
    }

    public void buildString(StringBuilder sb, boolean withLocation) {
        this.buildInnerString(sb);
        if (withLocation) {
            sb.append(' ');
            sb.append(this.getLocationString());
        }
    }

    protected void buildInnerString(StringBuilder sb) {
    }

    private void countDefinitions() {
        if ((CompilerDiagnosticsConstants.diagnostics & 2) == 2) {
            System.out.println("DefinitionBase incrementing Counter for " + this.getClass().getSimpleName());
        }
        Counter counter = Counter.getInstance();
        counter.incrementCount(this.getClass().getSimpleName());
        counter.incrementCount("definitions");
        if ((CompilerDiagnosticsConstants.diagnostics & 2) == 2) {
            System.out.println("DefinitionBase done incrementing Counter for " + this.getClass().getSimpleName());
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getMaxSize() {
        return 1;
    }

    @Override
    public IDefinition getDefinition(int i) {
        assert (i == 0);
        return this;
    }

    @Override
    public boolean isInProject(ICompilerProject project) {
        ICompilationUnit compilationUnit = ((ASProjectScope)project.getScope()).getCompilationUnitForDefinition(this);
        if (compilationUnit != null) {
            return compilationUnit.getProject() == project;
        }
        if (AppliedVectorDefinition.isVectorScope(this.getContainingASScope())) {
            IDefinition parentDef = this.getParent();
            return parentDef.isInProject(project);
        }
        return false;
    }
}

