/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.value.StringValue;

public class ATokenIterator
implements AtomicIterator {
    private final UnicodeString input;
    private final REMatcher matcher;
    private StringValue current;
    private int prevEnd;

    public ATokenIterator(UnicodeString input, REMatcher matcher) {
        this.input = input;
        this.matcher = matcher;
        this.prevEnd = 0;
    }

    @Override
    public StringValue next() {
        if (this.prevEnd < 0) {
            this.current = null;
            return null;
        }
        if (this.matcher.match(this.input, this.prevEnd)) {
            int start = this.matcher.getParenStart(0);
            this.current = new StringValue(this.input.substring(this.prevEnd, start));
            this.prevEnd = this.matcher.getParenEnd(0);
        } else {
            this.current = new StringValue(this.input.substring(this.prevEnd));
            this.prevEnd = -1;
        }
        return this.currentStringValue();
    }

    private StringValue currentStringValue() {
        return this.current;
    }
}

