/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.convert;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class FileToStringSampleStream
extends FilterObjectStream<File, String> {
    private final Charset encoding;

    public FileToStringSampleStream(ObjectStream<File> samples, Charset encoding) {
        super(samples);
        this.encoding = encoding;
    }

    private static String readFile(File textFile, Charset encoding) throws IOException {
        StringBuilder text = new StringBuilder();
        try (BufferedReader in = Files.newBufferedReader(textFile.toPath(), encoding);){
            int length;
            char[] buffer = new char[1024];
            while ((length = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                text.append(buffer, 0, length);
            }
        }
        return text.toString();
    }

    public String read() throws IOException {
        File sampleFile = (File)this.samples.read();
        if (sampleFile != null) {
            return FileToStringSampleStream.readFile(sampleFile, this.encoding);
        }
        return null;
    }
}

