/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common.tree;

import jakarta.inject.Inject;
import org.apache.openmeetings.db.dao.file.FileItemLogDao;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.web.common.tree.FileTreePanel;
import org.apache.openmeetings.web.common.tree.FolderPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class FileItemPanel
extends FolderPanel {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer errors = new WebMarkupContainer("errors");
    @Inject
    private FileItemLogDao fileLogDao;

    public FileItemPanel(String id, final IModel<BaseFileItem> model, final FileTreePanel fileTreePanel) {
        super(id, model, fileTreePanel);
        Recording r;
        boolean visible;
        BaseFileItem f = (BaseFileItem)model.getObject();
        long errorCount = this.fileLogDao.countErrors(f);
        boolean bl = visible = errorCount != 0L;
        visible = BaseFileItem.Type.RECORDING == f.getType() ? (visible |= Recording.Status.RECORDING != (r = (Recording)f).getStatus() && Recording.Status.CONVERTING != r.getStatus() && !f.exists()) : (visible |= !f.exists());
        this.errors.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                fileTreePanel.errorsDialog.setDefaultModel(model);
                fileTreePanel.errorsDialog.show((IPartialPageRequestHandler)target);
            }
        }}).setVisible(visible);
        this.add(new Component[]{this.errors});
    }
}

