/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.DecodeOptions;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.io.RandomAccessInputStream;
import org.apache.pdfbox.io.RandomAccessRead;

public final class COSInputStream
extends FilterInputStream {
    private final List<DecodeResult> decodeResults;

    static COSInputStream create(List<Filter> filters, COSDictionary parameters, InputStream in) throws IOException {
        return COSInputStream.create(filters, parameters, in, DecodeOptions.DEFAULT);
    }

    static COSInputStream create(List<Filter> filters, COSDictionary parameters, InputStream in, DecodeOptions options) throws IOException {
        if (filters.isEmpty()) {
            return new COSInputStream(in, Collections.emptyList());
        }
        ArrayList<DecodeResult> results = new ArrayList<DecodeResult>(filters.size());
        RandomAccessRead decoded = Filter.decode(in, filters, parameters, options, results);
        return new COSInputStream((InputStream)new RandomAccessInputStream(decoded), results);
    }

    private COSInputStream(InputStream input, List<DecodeResult> decodeResults) {
        super(input);
        this.decodeResults = decodeResults;
    }

    public DecodeResult getDecodeResult() {
        if (this.decodeResults.isEmpty()) {
            return DecodeResult.createDefault();
        }
        return this.decodeResults.get(this.decodeResults.size() - 1);
    }
}

