/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.idealized.target.model.SessionID;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.WebSocket;

public class Connection
implements Closeable {
    private static final Logger LOG = Logger.getLogger(Connection.class.getName());
    private static final Json JSON = new Json();
    private static final Executor EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r, "CDP Connection");
        thread.setDaemon(true);
        return thread;
    });
    private static final AtomicLong NEXT_ID = new AtomicLong(1L);
    private final WebSocket socket;
    private final Map<Long, Consumer<Either<Throwable, JsonInput>>> methodCallbacks = new ConcurrentHashMap<Long, Consumer<Either<Throwable, JsonInput>>>();
    private final ReadWriteLock callbacksLock = new ReentrantReadWriteLock(true);
    private final Multimap<Event<?>, Consumer<?>> eventCallbacks = HashMultimap.create();
    private final HttpClient client;

    public Connection(HttpClient client, String url) {
        Require.nonNull((String)"HTTP client", (Object)client);
        Require.nonNull((String)"URL to connect to", (Object)url);
        this.client = client;
        this.socket = this.client.openSocket(new HttpRequest(HttpMethod.GET, url), (WebSocket.Listener)new Listener());
    }

    public <X> CompletableFuture<X> send(SessionID sessionId, Command<X> command) {
        long id = NEXT_ID.getAndIncrement();
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (command.getSendsResponse()) {
            this.methodCallbacks.put(id, NamedConsumer.of(command.getMethod(), inputOrException -> {
                if (inputOrException.isRight()) {
                    try {
                        Object value = command.getMapper().apply((JsonInput)inputOrException.right());
                        result.complete(value);
                    }
                    catch (Throwable e) {
                        LOG.log(Level.WARNING, String.format("Unable to map result for %s", command.getMethod()), e);
                        result.completeExceptionally(e);
                    }
                } else {
                    result.completeExceptionally((Throwable)inputOrException.left());
                }
            }));
        }
        ImmutableMap.Builder serialized = ImmutableMap.builder();
        serialized.put((Object)"id", (Object)id);
        serialized.put((Object)"method", (Object)command.getMethod());
        serialized.put((Object)"params", command.getParams());
        if (sessionId != null) {
            serialized.put((Object)"sessionId", (Object)sessionId);
        }
        StringBuilder json = new StringBuilder();
        try (JsonOutput out = JSON.newOutput((Appendable)json).writeClassName(false);){
            out.write((Object)serialized.build());
        }
        LOG.log(Debug.getDebugLogLevel(), () -> String.format("-> %s", json));
        this.socket.sendText((CharSequence)json);
        if (!command.getSendsResponse()) {
            result.complete(null);
        }
        return result;
    }

    public <X> X sendAndWait(SessionID sessionId, Command<X> command, Duration timeout) {
        try {
            CompletableFuture<X> future = this.send(sessionId, command);
            return future.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread has been interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            throw new DevToolsException(cause);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> void addListener(Event<X> event, Consumer<X> handler) {
        Require.nonNull((String)"Event to listen for", event);
        Require.nonNull((String)"Handler to call", handler);
        Lock lock = this.callbacksLock.writeLock();
        lock.lock();
        try {
            this.eventCallbacks.put(event, handler);
        }
        finally {
            lock.unlock();
        }
    }

    public void clearListeners() {
        Lock lock = this.callbacksLock.writeLock();
        lock.lock();
        try {
            this.eventCallbacks.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void close() {
        this.socket.close();
        this.client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(CharSequence data) {
        block27: {
            String asString = String.valueOf(data);
            LOG.log(Debug.getDebugLogLevel(), () -> String.format("<- %s", asString));
            Map raw = (Map)JSON.toType(asString, Json.MAP_TYPE);
            if (raw.get("id") instanceof Number && (raw.get("result") != null || raw.get("error") != null)) {
                Consumer<Either<Throwable, JsonInput>> consumer = this.methodCallbacks.remove(((Number)raw.get("id")).longValue());
                if (consumer == null) {
                    return;
                }
                try (StringReader reader = new StringReader(asString);
                     JsonInput input = JSON.newInput((Reader)reader);){
                    input.beginObject();
                    block21: while (input.hasNext()) {
                        switch (input.nextName()) {
                            case "result": {
                                consumer.accept((Either<Throwable, JsonInput>)Either.right((Object)input));
                                continue block21;
                            }
                            case "error": {
                                consumer.accept((Either<Throwable, JsonInput>)Either.left((Object)new WebDriverException(asString)));
                                input.skipValue();
                                continue block21;
                            }
                        }
                        input.skipValue();
                    }
                    input.endObject();
                    break block27;
                }
            }
            if (raw.get("method") instanceof String && raw.get("params") instanceof Map) {
                LOG.log(Debug.getDebugLogLevel(), String.format("Method %s called with %d callbacks available", raw.get("method"), this.eventCallbacks.keySet().size()));
                Lock lock = this.callbacksLock.readLock();
                lock.lock();
                try {
                    this.eventCallbacks.keySet().stream().peek(event -> LOG.log(Debug.getDebugLogLevel(), String.format("Matching %s with %s", raw.get("method"), event.getMethod()))).filter(event -> raw.get("method").equals(event.getMethod())).forEach(event -> {
                        try (StringReader reader = new StringReader(asString);
                             JsonInput input = JSON.newInput((Reader)reader);){
                            Object value = null;
                            input.beginObject();
                            block18: while (input.hasNext()) {
                                switch (input.nextName()) {
                                    case "params": {
                                        value = event.getMapper().apply(input);
                                        continue block18;
                                    }
                                }
                                input.skipValue();
                            }
                            input.endObject();
                            if (value == null) {
                                return;
                            }
                            Object finalValue = value;
                            Iterator iterator = this.eventCallbacks.get(event).iterator();
                            while (iterator.hasNext()) {
                                Consumer action;
                                Consumer obj = action = (Consumer)iterator.next();
                                LOG.log(Debug.getDebugLogLevel(), String.format("Calling callback for %s using %s being passed %s", event, obj, finalValue));
                                obj.accept(finalValue);
                            }
                        }
                    });
                }
                finally {
                    lock.unlock();
                }
            } else {
                LOG.warning("Unhandled type: " + data);
            }
        }
    }

    private class Listener
    implements WebSocket.Listener {
        private Listener() {
        }

        public void onText(CharSequence data) {
            EXECUTOR.execute(() -> {
                try {
                    Connection.this.handle(data);
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Unable to process: " + data, t);
                    throw new DevToolsException(t);
                }
            });
        }
    }

    private static class NamedConsumer<X>
    implements Consumer<X> {
        private final String name;
        private final Consumer<X> delegate;

        private NamedConsumer(String name, Consumer<X> delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        public static <X> Consumer<X> of(String name, Consumer<X> delegate) {
            return new NamedConsumer<X>(name, delegate);
        }

        @Override
        public void accept(X x) {
            this.delegate.accept(x);
        }

        public String toString() {
            return "Consumer for " + this.name;
        }
    }
}

