/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.collect.Queues;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.nutch.fetcher.FetchNodeDb;
import org.apache.nutch.service.ConfManager;
import org.apache.nutch.service.JobManager;
import org.apache.nutch.service.SeedManager;
import org.apache.nutch.service.impl.ConfManagerImpl;
import org.apache.nutch.service.impl.JobFactory;
import org.apache.nutch.service.impl.JobManagerImpl;
import org.apache.nutch.service.impl.NutchServerPoolExecutor;
import org.apache.nutch.service.impl.SeedManagerImpl;
import org.apache.nutch.service.model.response.JobInfo;
import org.apache.nutch.service.resources.AdminResource;
import org.apache.nutch.service.resources.ConfigResource;
import org.apache.nutch.service.resources.DbResource;
import org.apache.nutch.service.resources.JobResource;
import org.apache.nutch.service.resources.ReaderResouce;
import org.apache.nutch.service.resources.SeedResource;
import org.apache.nutch.service.resources.ServicesResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NutchServer {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LOCALHOST = "localhost";
    private static final Integer DEFAULT_PORT;
    private static final int JOB_CAPACITY = 100;
    private static Integer port;
    private static String host;
    private static final String CMD_HELP = "help";
    private static final String CMD_PORT = "port";
    private static final String CMD_HOST = "host";
    private long started;
    private boolean running;
    private ConfManager configManager = new ConfManagerImpl();
    private JobManager jobManager;
    private SeedManager seedManager = new SeedManagerImpl();
    private JAXRSServerFactoryBean sf;
    private static FetchNodeDb fetchNodeDb;
    private static NutchServer server;

    private NutchServer() {
        ArrayBlockingQueue runnables = Queues.newArrayBlockingQueue((int)100);
        NutchServerPoolExecutor executor = new NutchServerPoolExecutor(10, 100, 1L, TimeUnit.HOURS, runnables);
        this.jobManager = new JobManagerImpl(new JobFactory(), this.configManager, executor);
        fetchNodeDb = FetchNodeDb.getInstance();
        this.sf = new JAXRSServerFactoryBean();
        BindingFactoryManager manager = (BindingFactoryManager)this.sf.getBus().getExtension(BindingFactoryManager.class);
        JAXRSBindingFactory factory = new JAXRSBindingFactory();
        factory.setBus(this.sf.getBus());
        manager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)factory);
        this.sf.setResourceClasses(this.getClasses());
        this.sf.setResourceProviders(this.getResourceProviders());
        this.sf.setProvider((Object)new JacksonJaxbJsonProvider());
    }

    public static NutchServer getInstance() {
        return server;
    }

    protected static void startServer() {
        server.start();
    }

    private void start() {
        LOG.info("Starting NutchServer on {}:{}  ...", (Object)host, (Object)port);
        try {
            String address = "http://" + host + ":" + port;
            this.sf.setAddress(address);
            this.sf.create();
        }
        catch (Exception e) {
            throw new IllegalStateException("Server could not be started", e);
        }
        this.started = System.currentTimeMillis();
        this.running = true;
        LOG.info("Started Nutch Server on {}:{} at {}", new Object[]{host, port, this.started});
    }

    private List<Class<?>> getClasses() {
        ArrayList resources = new ArrayList();
        resources.add(JobResource.class);
        resources.add(ConfigResource.class);
        resources.add(DbResource.class);
        resources.add(AdminResource.class);
        resources.add(SeedResource.class);
        resources.add(ReaderResouce.class);
        resources.add(ServicesResource.class);
        return resources;
    }

    private List<ResourceProvider> getResourceProviders() {
        ArrayList<ResourceProvider> resourceProviders = new ArrayList<ResourceProvider>();
        resourceProviders.add((ResourceProvider)new SingletonResourceProvider((Object)this.getConfManager()));
        return resourceProviders;
    }

    public ConfManager getConfManager() {
        return this.configManager;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public SeedManager getSeedManager() {
        return this.seedManager;
    }

    public FetchNodeDb getFetchNodeDb() {
        return fetchNodeDb;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getStarted() {
        return this.started;
    }

    public static void main(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        Options options = NutchServer.createOptions();
        CommandLine commandLine = parser.parse(options, args);
        if (commandLine.hasOption(CMD_HELP)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("NutchServer", options, true);
            return;
        }
        if (commandLine.hasOption(CMD_PORT)) {
            port = Integer.parseInt(commandLine.getOptionValue(CMD_PORT));
        }
        if (commandLine.hasOption(CMD_HOST)) {
            host = commandLine.getOptionValue(CMD_HOST);
        }
        NutchServer.startServer();
    }

    private static Options createOptions() {
        Options options = new Options();
        OptionBuilder.withDescription((String)"Show this help");
        options.addOption(OptionBuilder.create((String)CMD_HELP));
        OptionBuilder.withArgName((String)CMD_PORT);
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"The port to run the Nutch Server. Default port 8081");
        options.addOption(OptionBuilder.create((String)CMD_PORT));
        OptionBuilder.withArgName((String)CMD_HOST);
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"The host to bind the Nutch Server to. Default is localhost.");
        options.addOption(OptionBuilder.create((String)CMD_HOST));
        return options;
    }

    public boolean canStop(boolean force) {
        if (force) {
            return true;
        }
        Collection<JobInfo> jobs = this.getJobManager().list(null, JobInfo.State.RUNNING);
        return jobs.isEmpty();
    }

    protected static void setPort(int port) {
        NutchServer.port = port;
    }

    public int getPort() {
        return port;
    }

    public void stop() {
        System.exit(0);
    }

    static {
        port = DEFAULT_PORT = Integer.valueOf(8081);
        host = LOCALHOST;
        server = new NutchServer();
    }
}

