/*
 * Decompiled with CFR 0.152.
 */
package org.archive.uid;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;
import org.archive.uid.RecordIDGenerator;

public class UUIDGenerator
implements RecordIDGenerator {
    private static final String SCHEME = "urn:uuid";
    private static final String SCHEME_COLON = "urn:uuid:";

    @Override
    public URI qualifyRecordID(URI recordId, Map<String, String> qualifiers) {
        return this.getRecordID();
    }

    private String getUUID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public URI getRecordID() {
        try {
            return new URI(SCHEME_COLON + this.getUUID());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI getQualifiedRecordID(String key, String value) {
        return this.getRecordID();
    }

    @Override
    public URI getQualifiedRecordID(Map<String, String> qualifiers) {
        return this.getRecordID();
    }
}

