/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.tracing.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum StreamCompression {
    NONE("none"),
    GZIP("gzip");

    private String value;

    private StreamCompression(String value) {
        this.value = value;
    }

    public static StreamCompression fromString(String s) {
        return Arrays.stream(StreamCompression.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within StreamCompression "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static StreamCompression fromJson(JsonInput input) {
        return StreamCompression.fromString(input.nextString());
    }
}

