/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.bidi.network.InterceptPhase;
import org.openqa.selenium.bidi.network.UrlPattern;

public class AddInterceptParameters {
    private final List<String> phases = new ArrayList<String>();
    private final List<Map<String, String>> urlPatterns = new ArrayList<Map<String, String>>();

    public AddInterceptParameters(InterceptPhase phase) {
        this.phases.add(phase.toString());
    }

    public AddInterceptParameters(List<InterceptPhase> phases) {
        phases.forEach(phase -> this.phases.add(phase.toString()));
    }

    public AddInterceptParameters urlPattern(UrlPattern pattern) {
        this.urlPatterns.add(pattern.toMap());
        return this;
    }

    public AddInterceptParameters urlPatterns(List<UrlPattern> patterns) {
        patterns.forEach(pattern -> this.urlPatterns.add(pattern.toMap()));
        return this;
    }

    public AddInterceptParameters urlStringPattern(String pattern) {
        this.urlPatterns.add(Map.of("type", "string", "pattern", pattern));
        return this;
    }

    public AddInterceptParameters urlStringPatterns(List<String> patterns) {
        patterns.forEach(pattern -> this.urlPatterns.add(Map.of("type", "string", "pattern", pattern)));
        return this;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("phases", this.phases);
        if (!this.urlPatterns.isEmpty()) {
            map.put("urlPatterns", this.urlPatterns);
        }
        return map;
    }
}

