/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openqa.selenium.io.FileHandler;

public class TemporaryFilesystem {
    private final Set<File> temporaryFiles = new CopyOnWriteArraySet<File>();
    private final File baseDir;
    private final Thread shutdownHook = new Thread(this::deleteTemporaryFiles);
    private static final File sysTemp = new File(System.getProperty("java.io.tmpdir"));
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static TemporaryFilesystem instance = new TemporaryFilesystem(sysTemp);

    public static TemporaryFilesystem getDefaultTmpFS() {
        Lock readLock = lock.readLock();
        readLock.lock();
        try {
            TemporaryFilesystem temporaryFilesystem = instance;
            return temporaryFilesystem;
        }
        finally {
            readLock.unlock();
        }
    }

    public static void setTemporaryDirectory(File directory) {
        Lock writeLock = lock.writeLock();
        writeLock.lock();
        try {
            instance = new TemporaryFilesystem(directory);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static TemporaryFilesystem getTmpFsBasedOn(File directory) {
        return new TemporaryFilesystem(directory);
    }

    private TemporaryFilesystem(File baseDir) {
        this.baseDir = baseDir;
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        if (!baseDir.exists()) {
            throw new UncheckedIOException(new IOException("Unable to find tmp dir: " + baseDir.getAbsolutePath()));
        }
        if (!baseDir.canWrite()) {
            throw new UncheckedIOException(new IOException("Unable to write to tmp dir: " + baseDir.getAbsolutePath()));
        }
    }

    public File createTempDir(String prefix, String suffix) {
        try {
            File file = File.createTempFile(prefix, suffix, this.baseDir);
            if (!file.delete()) {
                throw new IOException("Unable to create temp file");
            }
            File dir = new File(file.getAbsolutePath());
            if (!dir.mkdirs()) {
                throw new UncheckedIOException(new IOException("Cannot create profile directory at " + dir.getAbsolutePath()));
            }
            FileHandler.createDir(dir);
            this.temporaryFiles.add(dir);
            return dir;
        }
        catch (IOException e) {
            throw new UncheckedIOException(new IOException("Unable to create temporary file at " + this.baseDir.getAbsolutePath()));
        }
    }

    public void deleteTempDir(File file) {
        if (!this.shouldReap()) {
            return;
        }
        if (this.temporaryFiles.remove(file)) {
            FileHandler.delete(file);
        }
    }

    public void deleteTemporaryFiles() {
        if (!this.shouldReap()) {
            return;
        }
        for (File file : this.temporaryFiles) {
            try {
                FileHandler.delete(file);
            }
            catch (UncheckedIOException uncheckedIOException) {}
        }
    }

    boolean shouldReap() {
        String reap = System.getProperty("webdriver.reap_profile", "true");
        return Boolean.parseBoolean(reap);
    }

    public boolean deleteBaseDir() {
        boolean wasDeleted = this.baseDir.delete();
        if (!this.baseDir.exists()) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        return wasDeleted;
    }

    public File getBaseDir() {
        return this.baseDir;
    }
}

