/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.rankeval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.opensearch.common.Nullable;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.index.rankeval.EvalQueryQuality;
import org.opensearch.index.rankeval.EvaluationMetric;
import org.opensearch.index.rankeval.MetricDetail;
import org.opensearch.index.rankeval.RatedDocument;
import org.opensearch.index.rankeval.RatedSearchHit;
import org.opensearch.search.SearchHit;

public class ExpectedReciprocalRank
implements EvaluationMetric {
    private static final int DEFAULT_K = 10;
    private final int k;
    private final Integer unknownDocRating;
    private final int maxRelevance;
    private final double two_pow_maxRelevance;
    public static final String NAME = "expected_reciprocal_rank";
    private static final ParseField K_FIELD = new ParseField("k", new String[0]);
    private static final ParseField UNKNOWN_DOC_RATING_FIELD = new ParseField("unknown_doc_rating", new String[0]);
    private static final ParseField MAX_RELEVANCE_FIELD = new ParseField("maximum_relevance", new String[0]);
    private static final ConstructingObjectParser<ExpectedReciprocalRank, Void> PARSER = new ConstructingObjectParser("dcg", false, args -> {
        int maxRelevance = (Integer)args[0];
        Integer optK = (Integer)args[2];
        return new ExpectedReciprocalRank(maxRelevance, (Integer)args[1], optK == null ? 10 : optK);
    });

    public ExpectedReciprocalRank(int maxRelevance) {
        this(maxRelevance, null, 10);
    }

    public ExpectedReciprocalRank(int maxRelevance, @Nullable Integer unknownDocRating, int k) {
        this.maxRelevance = maxRelevance;
        this.unknownDocRating = unknownDocRating;
        this.k = k;
        this.two_pow_maxRelevance = Math.pow(2.0, this.maxRelevance);
    }

    ExpectedReciprocalRank(StreamInput in) throws IOException {
        this.maxRelevance = in.readVInt();
        this.unknownDocRating = in.readOptionalVInt();
        this.k = in.readVInt();
        this.two_pow_maxRelevance = Math.pow(2.0, this.maxRelevance);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.maxRelevance);
        out.writeOptionalVInt(this.unknownDocRating);
        out.writeVInt(this.k);
    }

    public String getWriteableName() {
        return NAME;
    }

    int getK() {
        return this.k;
    }

    int getMaxRelevance() {
        return this.maxRelevance;
    }

    public Integer getUnknownDocRating() {
        return this.unknownDocRating;
    }

    @Override
    public OptionalInt forcedSearchSize() {
        return OptionalInt.of(this.k);
    }

    @Override
    public EvalQueryQuality evaluate(String taskId, SearchHit[] hits, List<RatedDocument> ratedDocs) {
        List<RatedSearchHit> ratedHits = EvaluationMetric.joinHitsWithRatings(hits, ratedDocs);
        if (ratedHits.size() > this.k) {
            ratedHits = ratedHits.subList(0, this.k);
        }
        ArrayList<Integer> ratingsInSearchHits = new ArrayList<Integer>(ratedHits.size());
        int unratedResults = 0;
        for (RatedSearchHit hit : ratedHits) {
            if (hit.getRating().isPresent()) {
                ratingsInSearchHits.add(hit.getRating().getAsInt());
            } else {
                ratingsInSearchHits.add(this.unknownDocRating);
            }
            if (hit.getRating().isPresent()) continue;
            ++unratedResults;
        }
        double p = 1.0;
        double err = 0.0;
        int rank = 1;
        for (Integer rating : ratingsInSearchHits) {
            if (rating != null) {
                double probR = this.probabilityOfRelevance(rating);
                err += p * probR / (double)rank;
                p *= 1.0 - probR;
            }
            ++rank;
        }
        EvalQueryQuality evalQueryQuality = new EvalQueryQuality(taskId, err);
        evalQueryQuality.addHitsAndRatings(ratedHits);
        evalQueryQuality.setMetricDetails(new Detail(unratedResults));
        return evalQueryQuality;
    }

    double probabilityOfRelevance(Integer rating) {
        return (Math.pow(2.0, rating.intValue()) - 1.0) / this.two_pow_maxRelevance;
    }

    public static ExpectedReciprocalRank fromXContent(XContentParser parser) {
        return (ExpectedReciprocalRank)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(MAX_RELEVANCE_FIELD.getPreferredName(), this.maxRelevance);
        if (this.unknownDocRating != null) {
            builder.field(UNKNOWN_DOC_RATING_FIELD.getPreferredName(), this.unknownDocRating);
        }
        builder.field(K_FIELD.getPreferredName(), this.k);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpectedReciprocalRank other = (ExpectedReciprocalRank)obj;
        return this.k == other.k && this.maxRelevance == other.maxRelevance && Objects.equals(this.unknownDocRating, other.unknownDocRating);
    }

    public final int hashCode() {
        return Objects.hash(this.unknownDocRating, this.k, this.maxRelevance);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), MAX_RELEVANCE_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), UNKNOWN_DOC_RATING_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), K_FIELD);
    }

    public static final class Detail
    implements MetricDetail {
        private static ParseField UNRATED_FIELD = new ParseField("unrated_docs", new String[0]);
        private final int unratedDocs;
        private static final ConstructingObjectParser<Detail, Void> PARSER = new ConstructingObjectParser("expected_reciprocal_rank", true, args -> new Detail((Integer)args[0]));

        Detail(int unratedDocs) {
            this.unratedDocs = unratedDocs;
        }

        Detail(StreamInput in) throws IOException {
            this.unratedDocs = in.readVInt();
        }

        @Override
        public String getMetricName() {
            return ExpectedReciprocalRank.NAME;
        }

        @Override
        public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(UNRATED_FIELD.getPreferredName(), this.unratedDocs);
        }

        public static Detail fromXContent(XContentParser parser) {
            return (Detail)PARSER.apply(parser, null);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.unratedDocs);
        }

        public String getWriteableName() {
            return ExpectedReciprocalRank.NAME;
        }

        public Object getUnratedDocs() {
            return this.unratedDocs;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Detail other = (Detail)obj;
            return this.unratedDocs == other.unratedDocs;
        }

        public int hashCode() {
            return Objects.hash(this.unratedDocs);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), UNRATED_FIELD);
        }
    }
}

