/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public abstract class ArrayValuesSourceAggregatorFactory
extends AggregatorFactory {
    protected Map<String, ValuesSourceConfig> configs;

    public ArrayValuesSourceAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.configs = configs;
    }

    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        HashMap<String, ValuesSource> valuesSources = new HashMap<String, ValuesSource>();
        for (Map.Entry<String, ValuesSourceConfig> config : this.configs.entrySet()) {
            ValuesSourceConfig vsc = config.getValue();
            if (!vsc.hasValues()) continue;
            valuesSources.put(config.getKey(), vsc.getValuesSource());
        }
        if (valuesSources.isEmpty()) {
            return this.createUnmapped(searchContext, parent, metadata);
        }
        return this.doCreateInternal(valuesSources, searchContext, parent, cardinality, metadata);
    }

    protected abstract Aggregator createUnmapped(SearchContext var1, Aggregator var2, Map<String, Object> var3) throws IOException;

    protected abstract Aggregator doCreateInternal(Map<String, ValuesSource> var1, SearchContext var2, Aggregator var3, CardinalityUpperBound var4, Map<String, Object> var5) throws IOException;
}

