/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.Closeable;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.compress.CompressorFactory;
import org.opensearch.common.io.stream.InputStreamStreamInput;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.transport.Header;
import org.opensearch.transport.InboundHandler;
import org.opensearch.transport.InboundMessage;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.TcpHeader;
import org.opensearch.transport.TransportStatus;

public final class TransportLogger {
    private static final Logger logger = LogManager.getLogger(TransportLogger.class);
    private static final int HEADER_SIZE = 6;

    static void logInboundMessage(TcpChannel channel, BytesReference message) {
        if (logger.isTraceEnabled()) {
            try {
                String logMessage = TransportLogger.format(channel, message, "READ");
                logger.trace(logMessage);
            }
            catch (IOException e) {
                logger.warn("an exception occurred formatting a READ trace message", (Throwable)e);
            }
        }
    }

    static void logInboundMessage(TcpChannel channel, InboundMessage message) {
        if (logger.isTraceEnabled()) {
            try {
                String logMessage = TransportLogger.format(channel, message, "READ");
                logger.trace(logMessage);
            }
            catch (IOException e) {
                logger.warn("an exception occurred formatting a READ trace message", (Throwable)e);
            }
        }
    }

    static void logOutboundMessage(TcpChannel channel, BytesReference message) {
        if (logger.isTraceEnabled()) {
            try {
                if (message.get(0) != 69) {
                    return;
                }
                BytesReference withoutHeader = message.slice(6, message.length() - 6);
                String logMessage = TransportLogger.format(channel, withoutHeader, "WRITE");
                logger.trace(logMessage);
            }
            catch (IOException e) {
                logger.warn("an exception occurred formatting a WRITE trace message", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(TcpChannel channel, BytesReference message, String event) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(channel);
        int messageLengthWithHeader = 6 + message.length();
        if (message.length() == 0) {
            sb.append(" [ping]").append(' ').append(event).append(": ").append(messageLengthWithHeader).append('B');
        } else {
            boolean success = false;
            StreamInput streamInput = message.streamInput();
            try {
                long requestId = streamInput.readLong();
                byte status = streamInput.readByte();
                boolean isRequest = TransportStatus.isRequest(status);
                String type = isRequest ? "request" : "response";
                Version version = Version.fromId(streamInput.readInt());
                streamInput.setVersion(version);
                sb.append(" [length: ").append(messageLengthWithHeader);
                sb.append(", request id: ").append(requestId);
                sb.append(", type: ").append(type);
                sb.append(", version: ").append(version);
                if (version.onOrAfter(TcpHeader.VERSION_WITH_HEADER_SIZE)) {
                    sb.append(", header size: ").append(streamInput.readInt()).append('B');
                } else {
                    streamInput = TransportLogger.decompressingStream(status, streamInput);
                    InboundHandler.assertRemoteVersion(streamInput, version);
                }
                ThreadContext.readHeadersFromStream(streamInput);
                if (isRequest) {
                    if (streamInput.getVersion().onOrAfter(LegacyESVersion.V_6_3_0)) {
                        streamInput.readStringArray();
                    }
                    sb.append(", action: ").append(streamInput.readString());
                }
                sb.append(']');
                sb.append(' ').append(event).append(": ").append(messageLengthWithHeader).append('B');
                success = true;
            }
            finally {
                if (success) {
                    IOUtils.close((Closeable)streamInput);
                } else {
                    IOUtils.closeWhileHandlingException((Closeable)streamInput);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(TcpChannel channel, InboundMessage message, String event) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(channel);
        if (message.isPing()) {
            sb.append(" [ping]").append(' ').append(event).append(": ").append(6).append('B');
        } else {
            boolean success = false;
            Header header = message.getHeader();
            int networkMessageSize = header.getNetworkMessageSize();
            int messageLengthWithHeader = 6 + networkMessageSize;
            StreamInput streamInput = message.openOrGetStreamInput();
            try {
                long requestId = header.getRequestId();
                boolean isRequest = header.isRequest();
                String type = isRequest ? "request" : "response";
                String version = header.getVersion().toString();
                sb.append(" [length: ").append(messageLengthWithHeader);
                sb.append(", request id: ").append(requestId);
                sb.append(", type: ").append(type);
                sb.append(", version: ").append(version);
                if (!header.needsToReadVariableHeader() && isRequest) {
                    sb.append(", action: ").append(header.getActionName());
                }
                sb.append(']');
                sb.append(' ').append(event).append(": ").append(messageLengthWithHeader).append('B');
                success = true;
            }
            finally {
                if (success) {
                    IOUtils.close((Closeable)streamInput);
                } else {
                    IOUtils.closeWhileHandlingException((Closeable)streamInput);
                }
            }
        }
        return sb.toString();
    }

    private static StreamInput decompressingStream(byte status, StreamInput streamInput) throws IOException {
        if (TransportStatus.isCompress(status) && streamInput.available() > 0) {
            try {
                return new InputStreamStreamInput(CompressorFactory.COMPRESSOR.threadLocalInputStream(streamInput));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("stream marked as compressed, but is missing deflate header");
            }
        }
        return streamInput;
    }
}

