/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;

public final class FetchVersionPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) {
        if (!context.version()) {
            return null;
        }
        return new FetchSubPhaseProcessor(){
            NumericDocValues versions = null;

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                this.versions = readerContext.reader().getNumericDocValues("_version");
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                long version = -1L;
                if (this.versions != null && this.versions.advanceExact(hitContext.docId())) {
                    version = this.versions.longValue();
                }
                hitContext.hit().version(version < 0L ? -1L : version);
            }
        };
    }
}

