/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.bulk;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.opensearch.action.ActionListener;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkRequestHandler;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.Client;
import org.opensearch.common.Nullable;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.ByteSizeUnit;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.threadpool.Scheduler;

public class BulkProcessor
implements Closeable {
    private final int bulkActions;
    private final long bulkSize;
    private final Scheduler.Cancellable cancellableFlushTask;
    private final AtomicLong executionIdGen = new AtomicLong();
    private BulkRequest bulkRequest;
    private final Supplier<BulkRequest> bulkRequestSupplier;
    private final BulkRequestHandler bulkRequestHandler;
    private final Runnable onClose;
    private volatile boolean closed = false;
    private final ReentrantLock lock = new ReentrantLock();

    public static Builder builder(Client client, Listener listener, Scheduler flushScheduler, Scheduler retryScheduler, Runnable onClose) {
        Objects.requireNonNull(client, "client");
        Objects.requireNonNull(listener, "listener");
        return new Builder(client::bulk, listener, flushScheduler, retryScheduler, onClose);
    }

    @Deprecated
    public static Builder builder(Client client, Listener listener) {
        Objects.requireNonNull(client, "client");
        Objects.requireNonNull(listener, "listener");
        return new Builder(client::bulk, listener, client.threadPool(), client.threadPool(), () -> {});
    }

    public static Builder builder(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, Listener listener) {
        Objects.requireNonNull(consumer, "consumer");
        Objects.requireNonNull(listener, "listener");
        ScheduledThreadPoolExecutor flushScheduledThreadPoolExecutor = Scheduler.initScheduler(Settings.EMPTY);
        ScheduledThreadPoolExecutor retryScheduledThreadPoolExecutor = Scheduler.initScheduler(Settings.EMPTY);
        return new Builder(consumer, listener, BulkProcessor.buildScheduler(flushScheduledThreadPoolExecutor), BulkProcessor.buildScheduler(retryScheduledThreadPoolExecutor), () -> {
            Scheduler.terminate(flushScheduledThreadPoolExecutor, 10L, TimeUnit.SECONDS);
            Scheduler.terminate(retryScheduledThreadPoolExecutor, 10L, TimeUnit.SECONDS);
        });
    }

    private static Scheduler buildScheduler(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return (command, delay, executor) -> Scheduler.wrapAsScheduledCancellable(scheduledThreadPoolExecutor.schedule(command, delay.millis(), TimeUnit.MILLISECONDS));
    }

    BulkProcessor(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, Listener listener, int concurrentRequests, int bulkActions, ByteSizeValue bulkSize, @Nullable TimeValue flushInterval, Scheduler flushScheduler, Scheduler retryScheduler, Runnable onClose, Supplier<BulkRequest> bulkRequestSupplier) {
        this.bulkActions = bulkActions;
        this.bulkSize = bulkSize.getBytes();
        this.bulkRequest = bulkRequestSupplier.get();
        this.bulkRequestSupplier = bulkRequestSupplier;
        this.bulkRequestHandler = new BulkRequestHandler(consumer, backoffPolicy, listener, retryScheduler, concurrentRequests);
        this.cancellableFlushTask = this.startFlushTask(flushInterval, flushScheduler);
        this.onClose = onClose;
    }

    @Deprecated
    BulkProcessor(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, Listener listener, int concurrentRequests, int bulkActions, ByteSizeValue bulkSize, @Nullable TimeValue flushInterval, Scheduler scheduler, Runnable onClose, Supplier<BulkRequest> bulkRequestSupplier) {
        this(consumer, backoffPolicy, listener, concurrentRequests, bulkActions, bulkSize, flushInterval, scheduler, scheduler, onClose, bulkRequestSupplier);
    }

    @Override
    public void close() {
        try {
            this.awaitClose(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.closed) {
                boolean bl = true;
                return bl;
            }
            this.closed = true;
            this.cancellableFlushTask.cancel();
            if (this.bulkRequest.numberOfActions() > 0) {
                this.execute();
            }
            try {
                boolean bl = this.bulkRequestHandler.awaitClose(timeout, unit);
                this.onClose.run();
                return bl;
            }
            catch (Throwable throwable) {
                this.onClose.run();
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public BulkProcessor add(IndexRequest request) {
        return this.add((DocWriteRequest<?>)request);
    }

    public BulkProcessor add(DeleteRequest request) {
        return this.add((DocWriteRequest<?>)request);
    }

    public BulkProcessor add(DocWriteRequest<?> request) {
        this.internalAdd(request);
        return this;
    }

    boolean isOpen() {
        return !this.closed;
    }

    protected void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("bulk process already closed");
        }
    }

    private void internalAdd(DocWriteRequest<?> request) {
        Tuple<BulkRequest, Long> bulkRequestToExecute = null;
        this.lock.lock();
        try {
            this.ensureOpen();
            this.bulkRequest.add(request);
            bulkRequestToExecute = this.newBulkRequestIfNeeded();
        }
        finally {
            this.lock.unlock();
        }
        if (bulkRequestToExecute != null) {
            this.execute((BulkRequest)bulkRequestToExecute.v1(), (Long)bulkRequestToExecute.v2());
        }
    }

    public BulkProcessor add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws Exception {
        return this.add(data, defaultIndex, defaultType, null, xContentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkProcessor add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String defaultPipeline, XContentType xContentType) throws Exception {
        Tuple<BulkRequest, Long> bulkRequestToExecute = null;
        this.lock.lock();
        try {
            this.ensureOpen();
            this.bulkRequest.add(data, defaultIndex, defaultType, null, null, defaultPipeline, null, true, xContentType);
            bulkRequestToExecute = this.newBulkRequestIfNeeded();
        }
        finally {
            this.lock.unlock();
        }
        if (bulkRequestToExecute != null) {
            this.execute((BulkRequest)bulkRequestToExecute.v1(), (Long)bulkRequestToExecute.v2());
        }
        return this;
    }

    private Scheduler.Cancellable startFlushTask(TimeValue flushInterval, Scheduler scheduler) {
        if (flushInterval == null) {
            return new Scheduler.Cancellable(){

                @Override
                public boolean cancel() {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return true;
                }
            };
        }
        return scheduler.scheduleWithFixedDelay(new Flush(), flushInterval, "generic");
    }

    private Tuple<BulkRequest, Long> newBulkRequestIfNeeded() {
        this.ensureOpen();
        if (!this.isOverTheLimit()) {
            return null;
        }
        BulkRequest bulkRequest = this.bulkRequest;
        this.bulkRequest = this.bulkRequestSupplier.get();
        return new Tuple((Object)bulkRequest, (Object)this.executionIdGen.incrementAndGet());
    }

    private void execute(BulkRequest bulkRequest, long executionId) {
        this.bulkRequestHandler.execute(bulkRequest, executionId);
    }

    private void execute() {
        BulkRequest bulkRequest = this.bulkRequest;
        long executionId = this.executionIdGen.incrementAndGet();
        this.bulkRequest = this.bulkRequestSupplier.get();
        this.execute(bulkRequest, executionId);
    }

    private boolean isOverTheLimit() {
        if (this.bulkActions != -1 && this.bulkRequest.numberOfActions() >= this.bulkActions) {
            return true;
        }
        return this.bulkSize != -1L && this.bulkRequest.estimatedSizeInBytes() >= this.bulkSize;
    }

    public void flush() {
        this.lock.lock();
        try {
            this.ensureOpen();
            if (this.bulkRequest.numberOfActions() > 0) {
                this.execute();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    class Flush
    implements Runnable {
        Flush() {
        }

        @Override
        public void run() {
            BulkProcessor.this.lock.lock();
            try {
                if (BulkProcessor.this.closed) {
                    return;
                }
                if (BulkProcessor.this.bulkRequest.numberOfActions() == 0) {
                    return;
                }
                BulkProcessor.this.execute();
            }
            finally {
                BulkProcessor.this.lock.unlock();
            }
        }
    }

    public static class Builder {
        private final BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer;
        private final Listener listener;
        private final Scheduler flushScheduler;
        private final Scheduler retryScheduler;
        private final Runnable onClose;
        private int concurrentRequests = 1;
        private int bulkActions = 1000;
        private ByteSizeValue bulkSize = new ByteSizeValue(5L, ByteSizeUnit.MB);
        private TimeValue flushInterval = null;
        private BackoffPolicy backoffPolicy = BackoffPolicy.exponentialBackoff();
        private String globalIndex;
        private String globalType;
        private String globalRouting;
        private String globalPipeline;

        private Builder(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, Listener listener, Scheduler flushScheduler, Scheduler retryScheduler, Runnable onClose) {
            this.consumer = consumer;
            this.listener = listener;
            this.flushScheduler = flushScheduler;
            this.retryScheduler = retryScheduler;
            this.onClose = onClose;
        }

        public Builder setConcurrentRequests(int concurrentRequests) {
            this.concurrentRequests = concurrentRequests;
            return this;
        }

        public Builder setBulkActions(int bulkActions) {
            this.bulkActions = bulkActions;
            return this;
        }

        public Builder setBulkSize(ByteSizeValue bulkSize) {
            this.bulkSize = bulkSize;
            return this;
        }

        public Builder setFlushInterval(TimeValue flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public Builder setGlobalIndex(String globalIndex) {
            this.globalIndex = globalIndex;
            return this;
        }

        public Builder setGlobalType(String globalType) {
            this.globalType = globalType;
            return this;
        }

        public Builder setGlobalRouting(String globalRouting) {
            this.globalRouting = globalRouting;
            return this;
        }

        public Builder setGlobalPipeline(String globalPipeline) {
            this.globalPipeline = globalPipeline;
            return this;
        }

        public Builder setBackoffPolicy(BackoffPolicy backoffPolicy) {
            if (backoffPolicy == null) {
                throw new NullPointerException("'backoffPolicy' must not be null. To disable backoff, pass BackoffPolicy.noBackoff()");
            }
            this.backoffPolicy = backoffPolicy;
            return this;
        }

        public BulkProcessor build() {
            return new BulkProcessor(this.consumer, this.backoffPolicy, this.listener, this.concurrentRequests, this.bulkActions, this.bulkSize, this.flushInterval, this.flushScheduler, this.retryScheduler, this.onClose, this.createBulkRequestWithGlobalDefaults());
        }

        private Supplier<BulkRequest> createBulkRequestWithGlobalDefaults() {
            return () -> new BulkRequest(this.globalIndex, this.globalType).pipeline(this.globalPipeline).routing(this.globalRouting);
        }
    }

    public static interface Listener {
        public void beforeBulk(long var1, BulkRequest var3);

        public void afterBulk(long var1, BulkRequest var3, BulkResponse var4);

        public void afterBulk(long var1, BulkRequest var3, Throwable var4);
    }
}

