/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.ComplianceUtils;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotedQualityCSV
extends QuotedCSV
implements Iterable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(QuotedQualityCSV.class);
    public static ToIntFunction<String> MOST_SPECIFIC_MIME_ORDERING = s -> {
        if ("*/*".equals(s)) {
            return 0;
        }
        if (s.endsWith("/*")) {
            return 1;
        }
        if (s.indexOf(59) < 0) {
            return 2;
        }
        return 3;
    };
    private final List<QualityValue> _qualities = new ArrayList<QualityValue>();
    private final ComplianceViolation.Mode _compliance;
    private final ComplianceViolation.Listener _listener;
    private final ToIntFunction<String> _secondaryOrdering;
    private QualityValue _lastQualityValue;
    private boolean _sorted = false;

    public QuotedQualityCSV() {
        this((ToIntFunction<String>)null);
    }

    public QuotedQualityCSV(String[] preferredOrder) {
        this(List.of(preferredOrder));
    }

    public QuotedQualityCSV(List<String> preferredOrder) {
        this(QuotedQualityCSV.secondaryOrdering(preferredOrder));
    }

    public QuotedQualityCSV(ToIntFunction<String> secondaryOrdering) {
        this(null, null, secondaryOrdering);
    }

    public QuotedQualityCSV(ComplianceViolation.Mode compliance, ComplianceViolation.Listener listener, ToIntFunction<String> secondaryOrdering) {
        super(new String[0]);
        this._compliance = compliance;
        this._listener = listener;
        this._secondaryOrdering = secondaryOrdering == null ? s -> 0 : secondaryOrdering;
    }

    private QuotedQualityCSV(ComplianceViolation.Mode compliance, ComplianceViolation.Listener listener, List<String> preferredOrder) {
        this(compliance, listener, QuotedQualityCSV.secondaryOrdering(preferredOrder));
    }

    private static ToIntFunction<String> secondaryOrdering(List<String> preferredOrder) {
        return s -> {
            for (int i = 0; i < preferredOrder.size(); ++i) {
                if (!((String)preferredOrder.get(i)).equals(s)) continue;
                return preferredOrder.size() - i;
            }
            if ("*".equals(s)) {
                return preferredOrder.size();
            }
            return 0;
        };
    }

    @Override
    protected void parsedValueAndParams(StringBuilder buffer) {
        if (buffer.isEmpty()) {
            return;
        }
        super.parsedValueAndParams(buffer);
        String value = buffer.toString();
        if (StringUtil.isBlank((String)value)) {
            return;
        }
        if (this._lastQualityValue != null) {
            this._lastQualityValue = new QualityValue(value, this._lastQualityValue._quality, this._lastQualityValue._index);
            this._qualities.set(this._lastQualityValue._index, this._lastQualityValue);
        }
    }

    @Override
    protected void parsedValue(StringBuilder buffer) {
        if (buffer.isEmpty()) {
            return;
        }
        String value = buffer.toString();
        if (StringUtil.isBlank((String)value)) {
            return;
        }
        this._lastQualityValue = new QualityValue(value, 1.0, this._qualities.size());
        this._qualities.add(this._lastQualityValue);
    }

    @Override
    protected void parsedParam(StringBuilder buffer, int valueLength, int paramName, int paramValue) {
        if (valueLength <= 0) {
            return;
        }
        this._sorted = false;
        if (paramName < 0) {
            if (buffer.charAt(buffer.length() - 1) == ';') {
                buffer.setLength(buffer.length() - 1);
            }
        } else if (paramValue >= 0 && buffer.charAt(paramName) == 'q' && paramValue > paramName && buffer.length() >= paramName && buffer.charAt(paramName + 1) == '=') {
            double q;
            try {
                q = this._keepQuotes && buffer.charAt(paramValue) == '\"' ? Double.valueOf(buffer.substring(paramValue + 1, buffer.length() - 1)) : Double.valueOf(buffer.substring(paramValue));
            }
            catch (Exception e) {
                LOG.trace("IGNORED", (Throwable)e);
                q = 0.0;
            }
            buffer.setLength(Math.max(0, paramName - 1));
            if (q != 1.0) {
                this._lastQualityValue = new QualityValue(buffer.toString(), q, this._lastQualityValue._index);
                this._qualities.set(this._lastQualityValue._index, this._lastQualityValue);
            }
        }
    }

    @Override
    public List<String> getValues() {
        if (!this._sorted) {
            this.sort();
        }
        return super.getValues();
    }

    @Override
    public Iterator<String> iterator() {
        if (!this._sorted) {
            this.sort();
        }
        return super.iterator();
    }

    protected void sort() {
        List<String> values = this.getMutableValues();
        values.clear();
        this._qualities.stream().filter(qv -> qv._quality != 0.0).sorted().map(QualityValue::getValue).collect(Collectors.toCollection(() -> values));
        this._sorted = true;
    }

    public List<QualityValue> getQualityValues() {
        return this._qualities.stream().sorted().toList();
    }

    @Override
    protected void onComplianceViolation(ComplianceViolation violation, String value) {
        if (this._compliance != null) {
            if (!ComplianceUtils.allows(this._compliance, violation, this._listener)) {
                throw new HttpException.RuntimeException(400, "Invalid quoted-quality: " + value);
            }
        } else {
            super.onComplianceViolation(violation, value);
        }
    }

    public class QualityValue
    implements Comparable<QualityValue> {
        private final String _value;
        private final double _quality;
        private final int _index;

        private QualityValue(String value, double quality, int index) {
            this._value = value;
            this._quality = quality;
            this._index = index;
        }

        public String getValue() {
            return this._value;
        }

        public double getWeight() {
            return this._quality;
        }

        public boolean isAcceptable() {
            return this.getWeight() > 0.0;
        }

        public int hashCode() {
            return Objects.hash(this._quality, this._value, this._index);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof QualityValue)) {
                return false;
            }
            QualityValue that = (QualityValue)obj;
            return this._quality == that._quality && Objects.equals(this._value, that._value) && this._index == that._index;
        }

        @Override
        public int compareTo(QualityValue o) {
            int compare = Double.compare(o._quality, this._quality);
            if (compare == 0 && (compare = Integer.compare(QuotedQualityCSV.this._secondaryOrdering.applyAsInt(o._value), QuotedQualityCSV.this._secondaryOrdering.applyAsInt(this._value))) == 0) {
                compare = -Integer.compare(o._index, this._index);
            }
            return compare;
        }

        public String toString() {
            return String.format(Locale.ROOT, "%s@%x[%s,q=%f,i=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getValue(), this.getWeight(), this._index);
        }
    }

    @Deprecated(since="12.1.6", forRemoval=true)
    public static class Compliant
    extends QuotedQualityCSV {
        public Compliant(ComplianceViolation.Mode complianceMode, BiConsumer<ComplianceViolation, String> violationNotifier, String[] preferredOrder) {
            this(complianceMode, violationNotifier, List.of(preferredOrder));
        }

        public Compliant(ComplianceViolation.Mode complianceMode, final BiConsumer<ComplianceViolation, String> violationNotifier, List<String> preferredOrder) {
            super(complianceMode, new ComplianceViolation.Listener(){

                @Override
                public void onComplianceViolation(ComplianceViolation.Event event) {
                    violationNotifier.accept(event.violation(), event.details());
                }
            }, preferredOrder);
        }

        public Compliant(ComplianceViolation.Mode complianceMode, final BiConsumer<ComplianceViolation, String> violationNotifier, ToIntFunction<String> secondaryOrdering) {
            super(complianceMode, new ComplianceViolation.Listener(){

                @Override
                public void onComplianceViolation(ComplianceViolation.Event event) {
                    violationNotifier.accept(event.violation(), event.details());
                }
            }, secondaryOrdering);
        }
    }
}

