/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl.request;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.nifi.toolkit.client.NiFiClientConfig;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.request.util.AccessToken;

public class OIDCClientCredentialsRequestConfig
implements RequestConfig {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String BEARER = "Bearer";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
    private AccessToken token;
    private final NiFiClientConfig niFiClientConfig;
    private final String oidcTokenUrl;
    private final String oidcClientId;
    private final String oidcClientSecret;

    public OIDCClientCredentialsRequestConfig(NiFiClientConfig niFiClientConfig, String oidcTokenUrl, String oidcClientId, String oidcClientSecret) {
        Objects.requireNonNull(oidcTokenUrl);
        Objects.requireNonNull(oidcClientId);
        Objects.requireNonNull(oidcClientSecret);
        Objects.requireNonNull(niFiClientConfig);
        this.niFiClientConfig = niFiClientConfig;
        this.oidcTokenUrl = oidcTokenUrl;
        this.oidcClientId = oidcClientId;
        this.oidcClientSecret = oidcClientSecret;
        this.setNewToken();
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.isRefreshRequired()) {
            this.setNewToken();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(AUTHORIZATION_HEADER, "Bearer " + this.token.getAccessToken());
        return headers;
    }

    private void setNewToken() {
        SSLContext sslContext = this.niFiClientConfig.getSslContext();
        HostnameVerifier hostnameVerifier = this.niFiClientConfig.getHostnameVerifier();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        if (hostnameVerifier != null) {
            clientBuilder.hostnameVerifier(hostnameVerifier);
        }
        Form form = new Form();
        form.param("grant_type", "client_credentials");
        form.param("client_id", this.oidcClientId);
        form.param("client_secret", this.oidcClientSecret);
        WebTarget target = clientBuilder.build().target(this.oidcTokenUrl);
        String response = (String)target.request().post(Entity.form((Form)form), String.class);
        try {
            this.token = (AccessToken)OBJECT_MAPPER.readValue(response, AccessToken.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isRefreshRequired() {
        Instant expirationRefreshTime = this.token.getFetchTime().plusSeconds(this.token.getExpiresIn()).minusSeconds(60L);
        return Instant.now().isAfter(expirationRefreshTime);
    }
}

