/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;

public class StandardFunnel
implements Funnel {
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final String DEFAULT_MAX_BACKOFF_PERIOD = "10 mins";
    private final String identifier;
    private final Set<Connection> outgoingConnections;
    private final List<Connection> incomingConnections;
    private final List<Relationship> relationships;
    private final AtomicReference<ProcessGroup> processGroupRef;
    private final AtomicReference<Position> position;
    private final AtomicReference<String> penalizationPeriod;
    private final AtomicReference<String> yieldPeriod;
    private final AtomicReference<String> schedulingPeriod;
    private final AtomicReference<String> name;
    private final AtomicLong schedulingNanos;
    private final AtomicBoolean lossTolerant;
    private final AtomicReference<ScheduledState> scheduledState;
    private final AtomicLong yieldExpiration;
    private final AtomicReference<String> versionedComponentId = new AtomicReference();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    final int maxIterations;
    private final int maxConcurrentTasks;

    public StandardFunnel(String identifier, int maxConcurrentTasks, int maxBatchSize) {
        this.identifier = identifier;
        this.processGroupRef = new AtomicReference();
        this.outgoingConnections = new HashSet<Connection>();
        this.incomingConnections = new ArrayList<Connection>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        relationships.add(Relationship.ANONYMOUS);
        this.relationships = Collections.unmodifiableList(relationships);
        this.lossTolerant = new AtomicBoolean(false);
        this.position = new AtomicReference<Position>(new Position(0.0, 0.0));
        this.scheduledState = new AtomicReference<ScheduledState>(ScheduledState.STOPPED);
        this.penalizationPeriod = new AtomicReference<String>("30 sec");
        this.yieldPeriod = new AtomicReference<String>("250 millis");
        this.yieldExpiration = new AtomicLong(0L);
        this.schedulingPeriod = new AtomicReference<String>("0 millis");
        this.schedulingNanos = new AtomicLong(1L);
        this.name = new AtomicReference<String>("Funnel");
        this.maxConcurrentTasks = maxConcurrentTasks;
        this.maxIterations = Math.max(1, (int)Math.ceil((double)maxBatchSize / 1000.0));
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup procGroup = this.getProcessGroup();
        return procGroup == null ? null : procGroup.getIdentifier();
    }

    @Override
    public Collection<Relationship> getRelationships() {
        return this.relationships;
    }

    @Override
    public Relationship getRelationship(String relationshipName) {
        return Relationship.ANONYMOUS.getName().equals(relationshipName) ? Relationship.ANONYMOUS : null;
    }

    public Authorizable getParentAuthorizable() {
        return this.getProcessGroup();
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.Funnel, (String)this.getIdentifier(), (String)this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(Connection connection) throws IllegalArgumentException {
        this.writeLock.lock();
        try {
            if (!Objects.requireNonNull(connection).getSource().equals(this) && !connection.getDestination().equals(this)) {
                throw new IllegalArgumentException("Cannot add a connection to a Funnel for which the Funnel is neither the Source nor the Destination");
            }
            if (connection.getSource().equals(this) && connection.getDestination().equals(this)) {
                throw new IllegalArgumentException("Cannot add a connection from a Funnel back to itself");
            }
            if (connection.getDestination().equals(this) && !this.incomingConnections.contains(connection)) {
                this.incomingConnections.add(connection);
            }
            if (connection.getSource().equals(this) && !this.outgoingConnections.contains(connection)) {
                for (Relationship relationship : connection.getRelationships()) {
                    if (relationship.equals((Object)Relationship.ANONYMOUS)) continue;
                    throw new IllegalArgumentException("No relationship with name " + String.valueOf(relationship) + " exists for Funnels");
                }
                this.outgoingConnections.add(connection);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean hasIncomingConnection() {
        this.readLock.lock();
        try {
            boolean bl = !this.incomingConnections.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void updateConnection(Connection connection) throws IllegalStateException {
        if (Objects.requireNonNull(connection).getSource().equals(this)) {
            this.writeLock.lock();
            try {
                if (!this.outgoingConnections.remove(connection)) {
                    throw new IllegalStateException("No Connection with ID " + connection.getIdentifier() + " is currently registered with this Funnel");
                }
                this.outgoingConnections.add(connection);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (connection.getDestination().equals(this)) {
            this.writeLock.lock();
            try {
                if (!this.incomingConnections.remove(connection)) {
                    throw new IllegalStateException("No Connection with ID " + connection.getIdentifier() + " is currently registered with this Funnel");
                }
                this.incomingConnections.add(connection);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public void removeConnection(Connection connection) throws IllegalArgumentException, IllegalStateException {
        this.writeLock.lock();
        try {
            if (!Objects.requireNonNull(connection).getSource().equals(this)) {
                boolean existed = this.incomingConnections.remove(connection);
                if (!existed) {
                    throw new IllegalStateException("The given connection is not currently registered for this Funnel");
                }
                return;
            }
            boolean removed = this.outgoingConnections.remove(connection);
            if (!removed) {
                throw new IllegalStateException(connection.getIdentifier() + " is not registered with " + this.getIdentifier());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<Connection> getConnections() {
        this.readLock.lock();
        try {
            Set<Connection> set = Collections.unmodifiableSet(this.outgoingConnections);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Connection> getConnections(Relationship relationship) {
        this.readLock.lock();
        try {
            if (relationship.equals((Object)Relationship.ANONYMOUS)) {
                Set<Connection> set = Collections.unmodifiableSet(this.outgoingConnections);
                return set;
            }
            throw new IllegalArgumentException("No relationship with name " + relationship.getName() + " exists for Funnels");
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<Connection> getIncomingConnections() {
        this.readLock.lock();
        try {
            ArrayList<Connection> arrayList = new ArrayList<Connection>(this.incomingConnections);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Position getPosition() {
        return this.position.get();
    }

    @Override
    public void setPosition(Position position) {
        this.position.set(position);
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getComments() {
        return "";
    }

    @Override
    public void setComments(String comments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProcessGroup getProcessGroup() {
        return this.processGroupRef.get();
    }

    @Override
    public void setProcessGroup(ProcessGroup group) {
        this.processGroupRef.set(group);
    }

    @Override
    public boolean isAutoTerminated(Relationship relationship) {
        return false;
    }

    public boolean isRunning() {
        return this.isRunning(this);
    }

    private boolean isRunning(Connectable source) {
        return this.getScheduledState() == ScheduledState.RUNNING;
    }

    @Override
    public boolean isTriggerWhenEmpty() {
        return false;
    }

    public ScheduledState getScheduledState() {
        return this.scheduledState.get();
    }

    @Override
    public boolean isLossTolerant() {
        return this.lossTolerant.get();
    }

    @Override
    public void setLossTolerant(boolean lossTolerant) {
        this.lossTolerant.set(lossTolerant);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.getIdentifier()).toString();
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        ProcessSession session = sessionFactory.createSession();
        try {
            this.onTrigger(context, session);
            session.commitAsync();
        }
        catch (ProcessException e) {
            session.rollback();
            throw e;
        }
        catch (Throwable t) {
            session.rollback();
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTrigger(ProcessContext context, ProcessSession session) {
        this.readLock.lock();
        try {
            Set available = context.getAvailableRelationships();
            int iterations = 0;
            while (!available.isEmpty()) {
                List flowFiles = session.get(1000);
                if (flowFiles.isEmpty()) {
                    break;
                }
                session.transfer((Collection)flowFiles, Relationship.ANONYMOUS);
                session.commitAsync();
                if (flowFiles.size() < 1000) break;
                if (++iterations >= this.maxIterations) {
                    break;
                }
                available = context.getAvailableRelationships();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setMaxConcurrentTasks(int taskCount) {
    }

    public int getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    @Override
    public void setScheduledState(ScheduledState scheduledState) {
        this.scheduledState.set(scheduledState);
    }

    @Override
    public ConnectableType getConnectableType() {
        return ConnectableType.FUNNEL;
    }

    @Override
    public Collection<ValidationResult> getValidationErrors() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void setYieldPeriod(String yieldPeriod) {
        long yieldMillis = FormatUtils.getTimeDuration((String)Objects.requireNonNull(yieldPeriod), (TimeUnit)TimeUnit.MILLISECONDS);
        if (yieldMillis < 0L) {
            throw new IllegalArgumentException("Yield duration must be positive");
        }
        this.yieldPeriod.set(yieldPeriod);
    }

    public void setSchedulingPeriod(String schedulingPeriod) {
        long schedulingNanos = FormatUtils.getTimeDuration((String)Objects.requireNonNull(schedulingPeriod), (TimeUnit)TimeUnit.NANOSECONDS);
        if (schedulingNanos < 0L) {
            throw new IllegalArgumentException("Scheduling Period must be positive");
        }
        this.schedulingPeriod.set(schedulingPeriod);
        this.schedulingNanos.set(Math.max(1L, schedulingNanos));
    }

    @Override
    public long getPenalizationPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getPenalizationPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    @Override
    public String getPenalizationPeriod() {
        return this.penalizationPeriod.get();
    }

    @Override
    public void yield() {
        long yieldMillis = this.getYieldPeriod(TimeUnit.MILLISECONDS);
        this.yield(yieldMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void yield(long yieldDuration, TimeUnit timeUnit) {
        long yieldMillis = timeUnit.toMillis(yieldDuration);
        this.yieldExpiration.set(Math.max(this.yieldExpiration.get(), System.currentTimeMillis() + yieldMillis));
    }

    @Override
    public long getYieldExpiration() {
        return this.yieldExpiration.get();
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod.get();
    }

    @Override
    public void setPenalizationPeriod(String penalizationPeriod) {
        this.penalizationPeriod.set(penalizationPeriod);
    }

    @Override
    public String getYieldPeriod() {
        return this.yieldPeriod.get();
    }

    @Override
    public long getYieldPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getYieldPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.schedulingNanos.get(), TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean isSideEffectFree() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyCanDelete(boolean ignoreConnections) throws IllegalStateException {
        if (ignoreConnections) {
            return;
        }
        this.readLock.lock();
        try {
            for (Connection connection : this.outgoingConnections) {
                connection.verifyCanDelete();
            }
            for (Connection connection : this.incomingConnections) {
                if (connection.getSource().equals(this)) {
                    connection.verifyCanDelete();
                    continue;
                }
                throw new IllegalStateException("Funnel " + this.getIdentifier() + " is the destination of another component");
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void verifyCanDelete() {
        this.verifyCanDelete(false);
    }

    @Override
    public void verifyCanStart() {
    }

    @Override
    public void verifyCanStop() {
    }

    @Override
    public void verifyCanUpdate() {
    }

    @Override
    public void verifyCanEnable() {
    }

    @Override
    public void verifyCanDisable() {
    }

    @Override
    public void verifyCanClearState() {
    }

    @Override
    public SchedulingStrategy getSchedulingStrategy() {
        return SchedulingStrategy.TIMER_DRIVEN;
    }

    @Override
    public String getComponentType() {
        return "Funnel";
    }

    @Override
    public int getRetryCount() {
        return 0;
    }

    @Override
    public void setRetryCount(Integer retryCount) {
    }

    @Override
    public Set<String> getRetriedRelationships() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void setRetriedRelationships(Set<String> retriedRelationships) {
    }

    @Override
    public boolean isRelationshipRetried(Relationship relationship) {
        return false;
    }

    @Override
    public BackoffMechanism getBackoffMechanism() {
        return BackoffMechanism.PENALIZE_FLOWFILE;
    }

    @Override
    public void setBackoffMechanism(BackoffMechanism backoffMechanism) {
    }

    @Override
    public String getMaxBackoffPeriod() {
        return DEFAULT_MAX_BACKOFF_PERIOD;
    }

    @Override
    public void setMaxBackoffPeriod(String maxBackoffPeriod) {
    }

    @Override
    public String evaluateParameters(String value) {
        return value;
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String versionedComponentId) {
        boolean updated = false;
        while (!updated) {
            String currentId = this.versionedComponentId.get();
            if (currentId == null) {
                updated = this.versionedComponentId.compareAndSet(null, versionedComponentId);
                continue;
            }
            if (currentId.equals(versionedComponentId)) {
                return;
            }
            if (versionedComponentId == null) {
                updated = this.versionedComponentId.compareAndSet(currentId, null);
                continue;
            }
            throw new IllegalStateException(String.valueOf(this) + " is already under version control");
        }
    }
}

