/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;

public class PGCreate
extends AbstractNiFiCommand<StringResult> {
    public PGCreate() {
        super("pg-create", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a process group child of the root group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_NAME.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String processGroupName = this.getRequiredArg(properties, CommandOption.PG_NAME);
        FlowClient flowClient = client.getFlowClient();
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        String rootPgId = flowClient.getRootGroupId();
        ProcessGroupDTO processGroupDTO = new ProcessGroupDTO();
        processGroupDTO.setParentGroupId(rootPgId);
        processGroupDTO.setName(processGroupName);
        ProcessGroupEntity pgEntity = new ProcessGroupEntity();
        pgEntity.setComponent(processGroupDTO);
        pgEntity.setRevision(this.getInitialRevisionDTO());
        ProcessGroupEntity createdEntity = pgClient.createProcessGroup(rootPgId, pgEntity);
        return new StringResult(createdEntity.getId(), this.getContext().isInteractive());
    }
}

