/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.params.AbstractUpdateParamContextCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.dto.AssetReferenceDTO;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;

public class RemoveAssetReference
extends AbstractUpdateParamContextCommand<VoidResult> {
    public RemoveAssetReference() {
        super("remove-asset-reference", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Removes an asset reference from a given parameter.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.PARAM_NAME.createOption());
        this.addOption(CommandOption.ASSET_ID.createOption());
        this.addOption(CommandOption.UPDATE_TIMEOUT.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        String paramName = this.getRequiredArg(properties, CommandOption.PARAM_NAME);
        String assetId = this.getRequiredArg(properties, CommandOption.ASSET_ID);
        int updateTimeout = this.getUpdateTimeout(properties);
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity existingParameterContextEntity = paramContextClient.getParamContext(paramContextId, false);
        ParameterContextDTO existingParameterContextDTO = existingParameterContextEntity.getComponent();
        ParameterDTO existingParam = existingParameterContextDTO.getParameters().stream().map(ParameterEntity::getParameter).filter(p -> p.getName().equals(paramName)).findFirst().orElseThrow(() -> new NiFiClientException("Parameter does not exist with the given name"));
        List assetReferences = existingParam.getReferencedAssets();
        if (assetReferences == null) {
            throw new NiFiClientException("Parameter does not reference any assets");
        }
        AssetReferenceDTO assetReferenceDTO = new AssetReferenceDTO(assetId);
        if (!assetReferences.contains(assetReferenceDTO)) {
            throw new NiFiClientException("Parameter does not reference the given asset");
        }
        assetReferences.remove(assetReferenceDTO);
        existingParam.setValue(null);
        ParameterContextEntity updatedParameterContextEntity = this.createContextEntityForUpdate(paramContextId, existingParam, existingParameterContextDTO.getInheritedParameterContexts(), existingParameterContextEntity.getRevision());
        ParameterContextUpdateRequestEntity updateRequestEntity = paramContextClient.updateParamContext(updatedParameterContextEntity);
        this.performUpdate(paramContextClient, updatedParameterContextEntity, updateRequestEntity, updateTimeout);
        if (this.isInteractive()) {
            this.println();
        }
        return VoidResult.getInstance();
    }
}

