/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental.migration;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.api.resource.LoadableResourceMetadata;
import org.flywaydb.core.experimental.migration.ExperimentalMigrationScanner;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resolver.ChecksumCalculator;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.resource.ResourceNameParser;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.util.Pair;

public class ExperimentalMigrationScannerManager {
    private static final Log LOG = LogFactory.getLog(ExperimentalMigrationScannerManager.class);
    private final List<? extends ExperimentalMigrationScanner> scanners;

    public ExperimentalMigrationScannerManager(Configuration configuration) {
        this(configuration.getPluginRegister().getPlugins(ExperimentalMigrationScanner.class));
    }

    public ExperimentalMigrationScannerManager(List<? extends ExperimentalMigrationScanner> scanners) {
        this.scanners = scanners;
    }

    public Collection<LoadableResourceMetadata> scan(Configuration configuration, ParsingContext parsingContext) {
        if (this.scanners.isEmpty()) {
            LOG.warn("No migrations scanners loaded");
        }
        List<LoadableResourceMetadata> resources = Arrays.stream(configuration.getLocations()).flatMap(location -> this.scan((Location)location, configuration, parsingContext).stream()).map(resource -> ExperimentalMigrationScannerManager.getLoadableResourceMetadata(resource, configuration, parsingContext)).toList();
        HashSet resourceSet = new HashSet();
        resources.forEach(resource -> {
            if (resourceSet.contains(resource)) {
                LoadableResourceMetadata first = resourceSet.stream().filter(loadableResourceMetadata -> loadableResourceMetadata.equals(resource)).findFirst().get();
                if (first.version() != null) {
                    throw new FlywayException(String.format("Found more than one migration with version %s\nOffenders:\n-> %s \n-> %s", resource.version(), resource.loadableResource().getAbsolutePath(), first.loadableResource().getAbsolutePath()), CoreErrorCode.DUPLICATE_VERSIONED_MIGRATION);
                }
                throw new FlywayException(String.format("Found more than one repeatable migration with description '%s'\nOffenders:\n-> %s \n-> %s ", resource.description(), resource.loadableResource().getAbsolutePath(), first.loadableResource().getAbsolutePath()), CoreErrorCode.DUPLICATE_REPEATABLE_MIGRATION);
            }
            resourceSet.add(resource);
        });
        return resources;
    }

    private static LoadableResourceMetadata getLoadableResourceMetadata(Pair<LoadableResource, SqlScriptMetadata> resource, Configuration configuration, ParsingContext parsingContext) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(configuration);
        ResourceName resourceName = resourceNameParser.parse(resource.getLeft().getFilename());
        SqlScriptMetadata sqlScriptMetadata = resource.getRight();
        boolean placeholderReplacement = sqlScriptMetadata == null || sqlScriptMetadata.placeholderReplacement() == null ? configuration.isPlaceholderReplacement() : sqlScriptMetadata.placeholderReplacement().booleanValue();
        int checksum = ExperimentalMigrationScannerManager.getChecksumForLoadableResource(Objects.equals(resourceName.getPrefix(), configuration.getRepeatableSqlMigrationPrefix()), placeholderReplacement, resource.getLeft(), resourceName, configuration, parsingContext);
        return new LoadableResourceMetadata(resourceName.getVersion(), resourceName.getDescription(), resourceName.getPrefix(), placeholderReplacement ? LoadableResource.createPlaceholderReplacingLoadableResource(resource.getLeft(), configuration, parsingContext) : resource.getLeft(), resource.getRight(), checksum, null);
    }

    private static Integer getChecksumForLoadableResource(boolean repeatable, boolean placeholderReplacement, LoadableResource resource, ResourceName resourceName, Configuration configuration, ParsingContext parsingContext) {
        if (repeatable && placeholderReplacement) {
            parsingContext.updateFilenamePlaceholder(resourceName, configuration);
            return ChecksumCalculator.calculate(LoadableResource.createPlaceholderReplacingLoadableResource(resource, configuration, parsingContext));
        }
        return ChecksumCalculator.calculate(resource);
    }

    private Collection<Pair<LoadableResource, SqlScriptMetadata>> scan(Location location, Configuration configuration, ParsingContext parsingContext) {
        return this.scanners.stream().flatMap(scanner -> scanner.scan(location, configuration, parsingContext).stream()).toList();
    }
}

