/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.mapping;

import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.StatelessGroupScheduledState;

public interface VersionedComponentStateLookup {
    public static final VersionedComponentStateLookup ENABLED_OR_DISABLED = new VersionedComponentStateLookup(){

        @Override
        public ScheduledState getState(ProcessorNode processorNode) {
            return processorNode.getScheduledState() == org.apache.nifi.controller.ScheduledState.DISABLED ? ScheduledState.DISABLED : ScheduledState.ENABLED;
        }

        @Override
        public ScheduledState getState(Port port) {
            return port.getScheduledState() == org.apache.nifi.controller.ScheduledState.DISABLED ? ScheduledState.DISABLED : ScheduledState.ENABLED;
        }

        @Override
        public ScheduledState getState(ReportingTaskNode taskNode) {
            return taskNode.getScheduledState() == org.apache.nifi.controller.ScheduledState.DISABLED ? ScheduledState.DISABLED : ScheduledState.ENABLED;
        }

        @Override
        public ScheduledState getState(FlowAnalysisRuleNode ruleNode) {
            return ruleNode.getState() == FlowAnalysisRuleState.DISABLED ? ScheduledState.DISABLED : ScheduledState.ENABLED;
        }

        @Override
        public ScheduledState getState(ControllerServiceNode serviceNode) {
            return ScheduledState.DISABLED;
        }

        @Override
        public ScheduledState getState(ProcessGroup group) {
            return ScheduledState.ENABLED;
        }
    };
    public static final VersionedComponentStateLookup IDENTITY_LOOKUP = new VersionedComponentStateLookup(){

        @Override
        public ScheduledState getState(ProcessorNode processorNode) {
            return this.map(processorNode.getDesiredState());
        }

        @Override
        public ScheduledState getState(Port port) {
            return this.map(port.getScheduledState());
        }

        @Override
        public ScheduledState getState(ReportingTaskNode taskNode) {
            return this.map(taskNode.getScheduledState());
        }

        @Override
        public ScheduledState getState(FlowAnalysisRuleNode ruleNode) {
            switch (ruleNode.getState()) {
                case DISABLED: {
                    return ScheduledState.DISABLED;
                }
            }
            return ScheduledState.ENABLED;
        }

        @Override
        public ScheduledState getState(ControllerServiceNode serviceNode) {
            switch (serviceNode.getState()) {
                case ENABLED: 
                case ENABLING: {
                    return ScheduledState.ENABLED;
                }
            }
            return ScheduledState.DISABLED;
        }

        @Override
        public ScheduledState getState(ProcessGroup group) {
            if (group.getDesiredStatelessScheduledState() == StatelessGroupScheduledState.RUNNING) {
                return ScheduledState.RUNNING;
            }
            return ScheduledState.ENABLED;
        }

        private ScheduledState map(org.apache.nifi.controller.ScheduledState componentState) {
            if (componentState == null) {
                return null;
            }
            switch (componentState) {
                case DISABLED: {
                    return ScheduledState.DISABLED;
                }
                case RUNNING: 
                case STARTING: {
                    return ScheduledState.RUNNING;
                }
            }
            return ScheduledState.ENABLED;
        }
    };

    public ScheduledState getState(ProcessorNode var1);

    public ScheduledState getState(Port var1);

    public ScheduledState getState(ReportingTaskNode var1);

    public ScheduledState getState(FlowAnalysisRuleNode var1);

    public ScheduledState getState(ControllerServiceNode var1);

    public ScheduledState getState(ProcessGroup var1);
}

