/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.encryptconfig.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.List;
import org.apache.nifi.toolkit.encryptconfig.util.ToolUtilities;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapUtil
implements GroovyObject {
    private static final String NIFI_BOOTSTRAP_KEY_PROPERTY = "nifi.bootstrap.sensitive.key";
    private static final String REGISTRY_BOOTSTRAP_KEY_PROPERTY = "nifi.registry.bootstrap.sensitive.key";
    private static final Logger logger;
    private static final String BOOTSTRAP_KEY_COMMENT = "# Root key in hexadecimal format for encrypted sensitive configuration values";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public BootstrapUtil() {
        MetaClass metaClass;
        CallSite[] callSiteArray = BootstrapUtil.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String extractKeyFromBootstrapFile(String inputBootstrapPath, String bootstrapKeyPropertyName) throws IOException {
        Reference bootstrapKeyPropertyName2 = new Reference((Object)bootstrapKeyPropertyName);
        CallSite[] callSiteArray = BootstrapUtil.$getCallSiteArray();
        File inputBootstrapConfFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(File.class, (Object)inputBootstrapPath), File.class);
        if (!(DefaultTypeTransformation.booleanUnbox((Object)inputBootstrapPath) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(ToolUtilities.class, (Object)inputBootstrapConfFile)))) {
            throw (Throwable)callSiteArray[2].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{inputBootstrapPath}, new String[]{"The bootstrap.conf file at ", " must exist and be readable by the user running this tool"}));
        }
        String keyValue = null;
        try {
            List lines = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call((Object)inputBootstrapConfFile), List.class);
            public final class _extractKeyFromBootstrapFile_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference bootstrapKeyPropertyName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _extractKeyFromBootstrapFile_closure1(Object _outerInstance, Object _thisObject, Reference bootstrapKeyPropertyName) {
                    Reference reference;
                    CallSite[] callSiteArray = _extractKeyFromBootstrapFile_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.bootstrapKeyPropertyName = reference = bootstrapKeyPropertyName;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _extractKeyFromBootstrapFile_closure1.$getCallSiteArray();
                    return callSiteArray[0].call(it, (Object)new GStringImpl(new Object[]{this.bootstrapKeyPropertyName.get()}, new String[]{"", "="}));
                }

                @Generated
                public String getBootstrapKeyPropertyName() {
                    CallSite[] callSiteArray = _extractKeyFromBootstrapFile_closure1.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.bootstrapKeyPropertyName.get());
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _extractKeyFromBootstrapFile_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _extractKeyFromBootstrapFile_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "startsWith";
                    return new CallSiteArray(_extractKeyFromBootstrapFile_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _extractKeyFromBootstrapFile_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            int keyLineIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[4].call((Object)lines, (Object)new _extractKeyFromBootstrapFile_closure1(BootstrapUtil.class, BootstrapUtil.class, bootstrapKeyPropertyName2)));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)keyLineIndex, (Object)-1)) {
                callSiteArray[5].call((Object)logger, (Object)"The key property was detected in bootstrap.conf");
                String keyLine = ShortTypeHandling.castToString((Object)callSiteArray[6].call((Object)lines, (Object)keyLineIndex));
                Object object = callSiteArray[7].call(callSiteArray[8].call((Object)keyLine, (Object)"=", (Object)2), (Object)1);
                keyValue = ShortTypeHandling.castToString((Object)object);
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(callSiteArray[10].call((Object)keyValue)))) {
                    Object var10_10 = null;
                    keyValue = ShortTypeHandling.castToString(var10_10);
                }
            } else {
                callSiteArray[11].call((Object)logger, (Object)"The key property was not detected in input bootstrap.conf.");
            }
        }
        catch (IOException e) {
            callSiteArray[12].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[13].call((Object)e)}, new String[]{"Encountered an exception reading the root key from the input bootstrap.conf file: ", ""}));
            throw (Throwable)e;
        }
        return keyValue;
    }

    public static void writeKeyToBootstrapFile(String keyHex, String bootstrapKeyPropertyName, String outputBootstrapPath, String inputBootstrapPath) throws IOException {
        CallSite[] callSiteArray = BootstrapUtil.$getCallSiteArray();
        File inputBootstrapConfFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].callConstructor(File.class, (Object)inputBootstrapPath), File.class);
        File outputBootstrapConfFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].callConstructor(File.class, (Object)outputBootstrapPath), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call(ToolUtilities.class, (Object)inputBootstrapConfFile))) {
            throw (Throwable)callSiteArray[17].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{inputBootstrapPath}, new String[]{"The bootstrap.conf file at ", " must exist and be readable by the user running this tool"}));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].call(ToolUtilities.class, (Object)outputBootstrapConfFile))) {
            throw (Throwable)callSiteArray[19].callConstructor(IOException.class, (Object)new GStringImpl(new Object[]{outputBootstrapPath}, new String[]{"The bootstrap.conf file at ", " must exist and be readable and writable by the user running this tool"}));
        }
        try {
            List lines = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call((Object)inputBootstrapConfFile), List.class);
            callSiteArray[21].callStatic(BootstrapUtil.class, (Object)lines, (Object)keyHex, (Object)bootstrapKeyPropertyName);
            Object object = callSiteArray[22].call((Object)lines, (Object)"\n");
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)outputBootstrapConfFile, (String)"text");
        }
        catch (IOException e) {
            callSiteArray[23].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[24].call((Object)e)}, new String[]{"Encountered an exception reading the root key from the input bootstrap.conf file: ", ""}));
            throw (Throwable)e;
        }
    }

    private static List<String> updateBootstrapContentsWithKey(List<String> lines, String newKeyHex, String bootstrapKeyPropertyName) {
        Reference bootstrapKeyPropertyName2 = new Reference((Object)bootstrapKeyPropertyName);
        CallSite[] callSiteArray = BootstrapUtil.$getCallSiteArray();
        String keyLine = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(String)bootstrapKeyPropertyName2.get(), newKeyHex}, new String[]{"", "=", ""}));
        public final class _updateBootstrapContentsWithKey_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference bootstrapKeyPropertyName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateBootstrapContentsWithKey_closure2(Object _outerInstance, Object _thisObject, Reference bootstrapKeyPropertyName) {
                Reference reference;
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.bootstrapKeyPropertyName = reference = bootstrapKeyPropertyName;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure2.$getCallSiteArray();
                return callSiteArray[0].call(it, (Object)new GStringImpl(new Object[]{this.bootstrapKeyPropertyName.get()}, new String[]{"", "="}));
            }

            @Generated
            public String getBootstrapKeyPropertyName() {
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.bootstrapKeyPropertyName.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _updateBootstrapContentsWithKey_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBootstrapContentsWithKey_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "startsWith";
                return new CallSiteArray(_updateBootstrapContentsWithKey_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateBootstrapContentsWithKey_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        int keyLineIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[25].call(lines, (Object)new _updateBootstrapContentsWithKey_closure2(BootstrapUtil.class, BootstrapUtil.class, bootstrapKeyPropertyName2)));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)keyLineIndex, (Object)-1)) {
            int n;
            int n2;
            callSiteArray[26].call((Object)logger, (Object)"The key property was detected in bootstrap.conf");
            String string = keyLine;
            callSiteArray[27].call(lines, (Object)keyLineIndex, (Object)string);
            callSiteArray[28].call((Object)logger, (Object)"The bootstrap key value was updated");
            int keyCommentLineIndex = 0;
            keyCommentLineIndex = !BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (n2 = keyLineIndex > 0 ? DefaultTypeTransformation.intUnbox((Object)callSiteArray[29].call((Object)keyLineIndex, (Object)1)) : 0) : (n = keyLineIndex > 0 ? keyLineIndex - 1 : 0);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[30].call(lines, (Object)keyCommentLineIndex), (Object)BOOTSTRAP_KEY_COMMENT)) {
                callSiteArray[31].call(lines, (Object)keyCommentLineIndex, (Object)BOOTSTRAP_KEY_COMMENT);
                callSiteArray[32].call((Object)logger, (Object)"A comment explaining the bootstrap key property was added");
            }
        } else {
            callSiteArray[33].call(lines, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"\n", BOOTSTRAP_KEY_COMMENT, keyLine}));
            callSiteArray[34].call((Object)logger, (Object)"The key property was not detected in bootstrap.conf so it was added along with a comment explaining it");
        }
        return lines;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BootstrapUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = BootstrapUtil.$getCallSiteArray()[35].call(LoggerFactory.class, BootstrapUtil.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public static String getNIFI_BOOTSTRAP_KEY_PROPERTY() {
        return NIFI_BOOTSTRAP_KEY_PROPERTY;
    }

    @Generated
    public static String getREGISTRY_BOOTSTRAP_KEY_PROPERTY() {
        return REGISTRY_BOOTSTRAP_KEY_PROPERTY;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "canRead";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "readLines";
        stringArray[4] = "findIndexOf";
        stringArray[5] = "debug";
        stringArray[6] = "getAt";
        stringArray[7] = "getAt";
        stringArray[8] = "split";
        stringArray[9] = "isEmpty";
        stringArray[10] = "trim";
        stringArray[11] = "debug";
        stringArray[12] = "error";
        stringArray[13] = "getMessage";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "canRead";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "isSafeToWrite";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "readLines";
        stringArray[21] = "updateBootstrapContentsWithKey";
        stringArray[22] = "join";
        stringArray[23] = "error";
        stringArray[24] = "getMessage";
        stringArray[25] = "findIndexOf";
        stringArray[26] = "debug";
        stringArray[27] = "putAt";
        stringArray[28] = "debug";
        stringArray[29] = "minus";
        stringArray[30] = "getAt";
        stringArray[31] = "add";
        stringArray[32] = "debug";
        stringArray[33] = "addAll";
        stringArray[34] = "debug";
        stringArray[35] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[36];
        BootstrapUtil.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(BootstrapUtil.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BootstrapUtil.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

