/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.str.TrimType;
import io.questdb.std.Chars;
import io.questdb.std.str.StringSink;

public class TrimFunction
extends StrFunction
implements UnaryFunction {
    private final Function arg;
    private final StringSink sink1 = new StringSink();
    private final StringSink sink2 = new StringSink();
    private final TrimType type;

    public TrimFunction(Function arg, TrimType type) {
        this.arg = arg;
        this.type = type;
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public String getName() {
        switch (this.type) {
            case LTRIM: {
                return "ltrim";
            }
            case RTRIM: {
                return "rtrim";
            }
        }
        return "trim";
    }

    @Override
    public CharSequence getStr(Record rec) {
        CharSequence charSequence = this.getArg().getStr(rec);
        if (charSequence == null) {
            return null;
        }
        Chars.trim(this.type, charSequence, this.sink1);
        return this.sink1;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        CharSequence charSequence = this.getArg().getStr(rec);
        if (charSequence == null) {
            return null;
        }
        Chars.trim(this.type, charSequence, this.sink2);
        return this.sink2;
    }

    @Override
    public int getStrLen(Record rec) {
        int len = this.arg.getStrLen(rec);
        if (len == -1) {
            return -1;
        }
        Chars.trim(this.type, this.getArg().getStr(rec), this.sink1);
        return this.sink1.length();
    }
}

