/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.AlterTableContextException;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.EmptySymbolMapReader;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.NullMemory;
import io.questdb.cairo.wal.CopyWalSegmentUtils;
import io.questdb.cairo.wal.MetadataService;
import io.questdb.cairo.wal.WalWriterEvents;
import io.questdb.cairo.wal.WalWriterMetadata;
import io.questdb.cairo.wal.WriterRowUtils;
import io.questdb.cairo.wal.seq.MetadataServiceStub;
import io.questdb.cairo.wal.seq.TableMetadataChange;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.AtomicIntList;
import io.questdb.std.BinarySequence;
import io.questdb.std.BoolList;
import io.questdb.std.ByteCharSequenceIntHashMap;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Uuid;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.ByteCharSequence;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.SingleCharCharSequence;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class WalWriter
implements TableWriterAPI {
    public static final int NEW_COL_RECORD_SIZE = 6;
    private static final long COLUMN_DELETED_NULL_FLAG = Long.MAX_VALUE;
    private static final Log LOG = LogFactory.getLog(WalWriter.class);
    private static final int MEM_TAG = 37;
    private static final Runnable NOOP = () -> {};
    private final AlterOperation alterOp = new AlterOperation();
    private final ObjList<MemoryMA> columns;
    private final CairoConfiguration configuration;
    private final WalWriterEvents events;
    private final FilesFacade ff;
    private final AtomicIntList initialSymbolCounts;
    private final IntList localSymbolIds;
    private final MetadataValidatorService metaValidatorSvc = new MetadataValidatorService();
    private final MetadataService metaWriterSvc = new MetadataWriterService();
    private final WalWriterMetadata metadata;
    private final int mkDirMode;
    private final ObjList<Runnable> nullSetters;
    private final Path path;
    private final int rootLen;
    private final RowImpl row = new RowImpl();
    private final LongList rowValueIsNotNull = new LongList();
    private final TableSequencerAPI sequencer;
    private final MemoryMAR symbolMapMem = Vm.getMARInstance();
    private final BoolList symbolMapNullFlags = new BoolList();
    private final ObjList<SymbolMapReader> symbolMapReaders = new ObjList();
    private final ObjList<CharSequenceIntHashMap> symbolMaps = new ObjList();
    private final ObjList<ByteCharSequenceIntHashMap> utf8SymbolMaps = new ObjList();
    private final Uuid uuid = new Uuid();
    private final int walId;
    private final String walName;
    private int columnCount;
    private ColumnVersionReader columnVersionReader;
    private long currentTxnStartRowNum = -1L;
    private boolean distressed;
    private int lastSegmentTxn = -1;
    private boolean open;
    private boolean rollSegmentOnNextRow = false;
    private int segmentId = -1;
    private int segmentLockFd = -1;
    private long segmentRowCount = -1L;
    private TableToken tableToken;
    private TxReader txReader;
    private long txnMaxTimestamp = -1L;
    private long txnMinTimestamp = Long.MAX_VALUE;
    private boolean txnOutOfOrder = false;
    private int walLockFd = -1;

    public WalWriter(CairoConfiguration configuration, TableToken tableToken, TableSequencerAPI tableSequencerAPI) {
        LOG.info().$("open '").utf8(tableToken.getDirName()).$('\'').$();
        this.sequencer = tableSequencerAPI;
        this.configuration = configuration;
        this.mkDirMode = configuration.getMkDirMode();
        this.ff = configuration.getFilesFacade();
        this.tableToken = tableToken;
        int walId = tableSequencerAPI.getNextWalId(tableToken);
        this.walName = "wal" + walId;
        this.walId = walId;
        this.path = new Path().of(configuration.getRoot()).concat(tableToken).concat(this.walName);
        this.rootLen = this.path.length();
        this.open = true;
        try {
            this.lockWal();
            this.mkWalDir();
            this.metadata = new WalWriterMetadata(this.ff);
            tableSequencerAPI.getTableMetadata(tableToken, this.metadata);
            this.columnCount = this.metadata.getColumnCount();
            this.columns = new ObjList(this.columnCount * 2);
            this.nullSetters = new ObjList(this.columnCount);
            this.initialSymbolCounts = new AtomicIntList(this.columnCount);
            this.localSymbolIds = new IntList(this.columnCount);
            this.events = new WalWriterEvents(this.ff);
            this.events.of(this.symbolMaps, this.initialSymbolCounts, this.symbolMapNullFlags);
            this.configureColumns();
            this.openNewSegment();
            this.configureSymbolTable();
        }
        catch (Throwable e) {
            this.doClose(false);
            throw e;
        }
    }

    @Override
    public void addColumn(CharSequence columnName, int columnType) {
        this.addColumn(columnName, columnType, this.configuration.getDefaultSymbolCapacity(), this.configuration.getDefaultSymbolCacheFlag(), false, this.configuration.getIndexValueBlockSize());
    }

    @Override
    public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity) {
        this.alterOp.clear();
        this.alterOp.ofAddColumn(this.getMetadata().getTableId(), this.tableToken, 0, columnName, 0, columnType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity);
        this.apply(this.alterOp, true);
    }

    @Override
    public long apply(AlterOperation alterOp, boolean contextAllowsAnyStructureChanges) throws AlterTableContextException {
        if (this.inTransaction()) {
            throw CairoException.critical(0).put("cannot alter table with uncommitted inserts [table=").put(this.tableToken.getTableName()).put(']');
        }
        if (alterOp.isStructural()) {
            return this.applyStructural(alterOp);
        }
        return this.applyNonStructural(alterOp, false);
    }

    @Override
    public long apply(UpdateOperation operation) {
        if (this.inTransaction()) {
            throw CairoException.critical(0).put("cannot update table with uncommitted inserts [table=").put(this.tableToken.getTableName()).put(']');
        }
        return this.applyNonStructural(operation, true);
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            try {
                this.rollback();
            }
            finally {
                this.doClose(true);
            }
        }
    }

    @Override
    public long commit() {
        this.checkDistressed();
        try {
            if (this.inTransaction()) {
                LOG.debug().$("committing data block [wal=").$(this.path).$(Files.SEPARATOR).$(this.segmentId).$(", rowLo=").$(this.currentTxnStartRowNum).$(", roHi=").$(this.segmentRowCount).I$();
                this.lastSegmentTxn = this.events.appendData(this.currentTxnStartRowNum, this.segmentRowCount, this.txnMinTimestamp, this.txnMaxTimestamp, this.txnOutOfOrder);
                long seqTxn = this.getSequencerTxn();
                this.resetDataTxnProperties();
                this.mayRollSegmentOnNextRow();
                return seqTxn;
            }
        }
        catch (CairoException ex) {
            this.distressed = true;
            throw ex;
        }
        catch (Throwable th) {
            if (!this.isDistressed()) {
                this.rollback();
            }
            throw th;
        }
        return Long.MIN_VALUE;
    }

    public void doClose(boolean truncate) {
        if (this.open) {
            this.open = false;
            this.metadata.close((byte)1);
            Misc.free(this.events);
            this.freeSymbolMapReaders();
            Misc.free(this.symbolMapMem);
            this.freeColumns(truncate);
            this.releaseSegmentLock();
            try {
                this.releaseWalLock();
            }
            finally {
                Misc.free(this.path);
                LOG.info().$("closed '").utf8(this.tableToken.getTableName()).$('\'').$();
            }
        }
    }

    @Override
    public TableRecordMetadata getMetadata() {
        return this.metadata;
    }

    public int getSegmentId() {
        return this.segmentId;
    }

    public long getSegmentRowCount() {
        return this.segmentRowCount;
    }

    @Override
    public long getStructureVersion() {
        return this.metadata.getStructureVersion();
    }

    @Override
    public int getSymbolCountWatermark(int columnIndex) {
        if (columnIndex > this.initialSymbolCounts.size() - 1) {
            return 0;
        }
        return this.initialSymbolCounts.get(columnIndex);
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public long getUncommittedRowCount() {
        return this.segmentRowCount - this.currentTxnStartRowNum;
    }

    public int getWalId() {
        return this.walId;
    }

    public String getWalName() {
        return this.walName;
    }

    public void goActive() {
        this.goActive(Long.MAX_VALUE);
    }

    public boolean goActive(long maxStructureVersion) {
        try {
            this.applyMetadataChangeLog(maxStructureVersion);
            return true;
        }
        catch (CairoException e) {
            LOG.critical().$("could not apply structure changes, WAL will be closed [table=").$(this.tableToken.getTableName()).$(", walId=").$(this.walId).$(", errno=").$(e.getErrno()).$(", error=").$(e).I$();
            this.distressed = true;
            return false;
        }
    }

    @Override
    public void ic() {
        this.commit();
    }

    @Override
    public void ic(long o3MaxLag) {
        this.commit();
    }

    public boolean inTransaction() {
        return this.segmentRowCount > this.currentTxnStartRowNum;
    }

    public boolean isDistressed() {
        return this.distressed;
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public TableWriter.Row newRow() {
        return this.newRow(0L);
    }

    @Override
    public TableWriter.Row newRow(long timestamp) {
        this.checkDistressed();
        if (timestamp < 0L) {
            throw CairoException.nonCritical().put("timestamp before 1970-01-01 is not allowed");
        }
        try {
            int timestampIndex;
            if (this.rollSegmentOnNextRow) {
                this.rollSegment();
                this.rollSegmentOnNextRow = false;
            }
            if ((timestampIndex = this.metadata.getTimestampIndex()) != -1) {
                MemoryMA primaryColumn = this.getPrimaryColumn(timestampIndex);
                primaryColumn.putLong128(timestamp, this.segmentRowCount);
                this.setRowValueNotNull(timestampIndex);
                this.row.timestamp = timestamp;
            }
            return this.row;
        }
        catch (Throwable e) {
            this.distressed = true;
            throw e;
        }
    }

    public void rollUncommittedToNewSegment() {
        long uncommittedRows = this.getUncommittedRowCount();
        int newSegmentId = this.segmentId + 1;
        this.path.trimTo(this.rootLen);
        if (uncommittedRows > 0L) {
            this.createSegmentDir(newSegmentId);
            this.path.trimTo(this.rootLen);
            LongList newColumnFiles = new LongList();
            newColumnFiles.setPos(this.columnCount * 6);
            newColumnFiles.fill(0, this.columnCount * 6, -1L);
            this.rowValueIsNotNull.fill(0, this.columnCount, -1L);
            try {
                int timestampIndex = this.metadata.getTimestampIndex();
                LOG.info().$("rolling uncommitted rows to new segment [wal=").$(this.path).$(Files.SEPARATOR).$(newSegmentId).$(", rowCount=").$(uncommittedRows).I$();
                for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                    int columnType = this.metadata.getColumnType(columnIndex);
                    if (columnType > 0) {
                        MemoryMA primaryColumn = this.getPrimaryColumn(columnIndex);
                        MemoryMA secondaryColumn = this.getSecondaryColumn(columnIndex);
                        String columnName = this.metadata.getColumnName(columnIndex);
                        CopyWalSegmentUtils.rollColumnToSegment(this.ff, this.configuration.getWriterFileOpenOpts(), primaryColumn, secondaryColumn, this.path, newSegmentId, columnName, columnIndex == timestampIndex ? -columnType : columnType, this.currentTxnStartRowNum, uncommittedRows, newColumnFiles, columnIndex);
                        continue;
                    }
                    this.rowValueIsNotNull.setQuick(columnIndex, Long.MAX_VALUE);
                }
            }
            catch (Throwable e) {
                this.closeSegmentSwitchFiles(newColumnFiles);
                throw e;
            }
            this.switchColumnsToNewSegment(newColumnFiles);
            this.rollLastWalEventRecord(newSegmentId, uncommittedRows);
            this.segmentId = newSegmentId;
            this.segmentRowCount = uncommittedRows;
            this.currentTxnStartRowNum = 0L;
        } else if (this.segmentRowCount > 0L && uncommittedRows == 0L) {
            this.rollSegmentOnNextRow = true;
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.inTransaction() || this.hasDirtyColumns(this.currentTxnStartRowNum)) {
                this.setAppendPosition(this.currentTxnStartRowNum);
                this.segmentRowCount = this.currentTxnStartRowNum;
                this.txnMinTimestamp = Long.MAX_VALUE;
                this.txnMaxTimestamp = -1L;
                this.txnOutOfOrder = false;
            }
        }
        catch (Throwable th) {
            this.distressed = true;
            throw th;
        }
    }

    @Override
    public boolean supportsMultipleWriters() {
        return true;
    }

    public String toString() {
        return "WalWriter{name=" + this.walName + ", table=" + this.tableToken.getTableName() + '}';
    }

    @Override
    public void truncate() {
        try {
            this.lastSegmentTxn = this.events.truncate();
            this.getSequencerTxn();
        }
        catch (Throwable th) {
            this.rollback();
            throw th;
        }
    }

    public void updateTableToken(TableToken tableToken) {
        this.tableToken = tableToken;
    }

    private static void configureNullSetters(ObjList<Runnable> nullers, int type, MemoryA mem1, MemoryA mem2) {
        switch (ColumnType.tagOf(type)) {
            case 1: 
            case 2: {
                nullers.add(() -> mem1.putByte((byte)0));
                break;
            }
            case 10: {
                nullers.add(() -> mem1.putDouble(Double.NaN));
                break;
            }
            case 9: {
                nullers.add(() -> mem1.putFloat(Float.NaN));
                break;
            }
            case 5: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                nullers.add(() -> mem1.putLong(Long.MIN_VALUE));
                break;
            }
            case 13: {
                nullers.add(() -> mem1.putLong256(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE));
                break;
            }
            case 3: {
                nullers.add(() -> mem1.putShort((short)0));
                break;
            }
            case 4: {
                nullers.add(() -> mem1.putChar('\u0000'));
                break;
            }
            case 11: {
                nullers.add(() -> mem2.putLong(mem1.putNullStr()));
                break;
            }
            case 12: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 18: {
                nullers.add(() -> mem2.putLong(mem1.putNullBin()));
                break;
            }
            case 14: {
                nullers.add(() -> mem1.putByte((byte)-1));
                break;
            }
            case 15: {
                nullers.add(() -> mem1.putShort((short)-1));
                break;
            }
            case 16: {
                nullers.add(() -> mem1.putInt(-1));
                break;
            }
            case 17: {
                nullers.add(() -> mem1.putLong(-1L));
                break;
            }
            case 19: 
            case 24: {
                nullers.add(() -> mem1.putLong128(Long.MIN_VALUE, Long.MIN_VALUE));
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported column type: " + ColumnType.nameOf(type));
            }
        }
    }

    private static void freeNullSetter(ObjList<Runnable> nullSetters, int columnIndex) {
        nullSetters.setQuick(columnIndex, NOOP);
    }

    private static int getPrimaryColumnIndex(int index) {
        return index * 2;
    }

    private static int getSecondaryColumnIndex(int index) {
        return WalWriter.getPrimaryColumnIndex(index) + 1;
    }

    private void applyMetadataChangeLog(long structureVersionHi) {
        try (TableMetadataChangeLog log = this.sequencer.getMetadataChangeLog(this.tableToken, this.metadata.getStructureVersion());){
            long structVer = this.getStructureVersion();
            while (log.hasNext() && structVer < structureVersionHi) {
                TableMetadataChange chg = log.next();
                try {
                    chg.apply(this.metaWriterSvc, true);
                }
                catch (CairoException e) {
                    this.distressed = true;
                    throw e;
                }
                if (++structVer == this.getStructureVersion()) continue;
                this.distressed = true;
                throw CairoException.critical(0).put("could not apply table definition changes to the current transaction, version unchanged");
            }
        }
    }

    private long applyNonStructural(AbstractOperation op, boolean verifyStructureVersion) {
        if (op.getSqlExecutionContext() == null) {
            throw CairoException.critical(0).put("failed to commit ALTER SQL to WAL, sql context is empty [table=").put(this.tableToken.getTableName()).put(']');
        }
        if (verifyStructureVersion && op.getTableVersion() != this.getStructureVersion() || op.getTableId() != this.metadata.getTableId()) {
            throw TableReferenceOutOfDateException.of(this.tableToken, this.metadata.getTableId(), op.getTableId(), this.getStructureVersion(), op.getTableVersion());
        }
        try {
            this.lastSegmentTxn = this.events.appendSql(op.getCmdType(), op.getSqlText(), op.getSqlExecutionContext());
            return this.getSequencerTxn();
        }
        catch (Throwable th) {
            this.distressed = true;
            throw th;
        }
    }

    private long applyStructural(AlterOperation alterOp) {
        long txn;
        do {
            boolean retry = true;
            try {
                this.metaValidatorSvc.startAlterValidation();
                alterOp.apply(this.metaValidatorSvc, true);
                if (this.metaValidatorSvc.structureVersion != this.metadata.getStructureVersion() + 1L) {
                    retry = false;
                    throw CairoException.nonCritical().put("statements containing multiple transactions, such as 'alter table add column col1, col2' are currently not supported for WAL tables [table=").put(this.tableToken.getTableName()).put(", oldStructureVersion=").put(this.metadata.getStructureVersion()).put(", newStructureVersion=").put(this.metaValidatorSvc.structureVersion).put(']');
                }
            }
            catch (CairoException e) {
                if (retry) {
                    this.goActive();
                    alterOp.apply(this.metaValidatorSvc, true);
                }
                throw e;
            }
            try {
                txn = this.sequencer.nextStructureTxn(this.tableToken, this.metadata.getStructureVersion(), alterOp);
                if (txn != Long.MIN_VALUE) continue;
                this.applyMetadataChangeLog(Long.MAX_VALUE);
            }
            catch (CairoException e) {
                this.distressed = true;
                throw e;
            }
        } while (txn == Long.MIN_VALUE);
        try {
            alterOp.apply(this.metaWriterSvc, true);
        }
        catch (Throwable th) {
            LOG.error().$("Exception during alter [ex=").$(th).I$();
            this.distressed = true;
        }
        return txn;
    }

    private void checkDistressed() {
        if (!this.distressed) {
            return;
        }
        throw CairoException.critical(0).put("WAL writer is distressed and cannot be used any more [table=").put(this.tableToken.getTableName()).put(", wal=").put(this.walId).put(']');
    }

    private void cleanupSymbolMapFiles(Path path, int rootLen, CharSequence columnName) {
        path.trimTo(rootLen);
        BitmapIndexUtils.valueFileName(path, columnName, -1L);
        this.ff.remove(path.$());
        path.trimTo(rootLen);
        BitmapIndexUtils.keyFileName(path, columnName, -1L);
        this.ff.remove(path.$());
        path.trimTo(rootLen);
        TableUtils.charFileName(path, columnName, -1L);
        this.ff.remove(path.$());
        path.trimTo(rootLen);
        TableUtils.offsetFileName(path, columnName, -1L);
        this.ff.remove(path.$());
    }

    private void closeSegmentSwitchFiles(LongList newColumnFiles) {
        int halfRecord = 3;
        for (int fdIndex = 0; fdIndex < newColumnFiles.size(); fdIndex += halfRecord) {
            int fd = (int)newColumnFiles.get(fdIndex);
            this.ff.close(fd);
        }
    }

    private void configureColumn(int index, int columnType) {
        int baseIndex = WalWriter.getPrimaryColumnIndex(index);
        if (columnType > 0) {
            MemoryMA primary = Vm.getMAInstance();
            MemoryMA secondary = this.createSecondaryMem(columnType);
            this.columns.extendAndSet(baseIndex, primary);
            this.columns.extendAndSet(baseIndex + 1, secondary);
            WalWriter.configureNullSetters(this.nullSetters, columnType, primary, secondary);
            this.rowValueIsNotNull.add(-1L);
        } else {
            this.columns.extendAndSet(baseIndex, NullMemory.INSTANCE);
            this.columns.extendAndSet(baseIndex + 1, NullMemory.INSTANCE);
            this.nullSetters.add(NOOP);
            this.rowValueIsNotNull.add(Long.MAX_VALUE);
        }
    }

    private void configureColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            this.configureColumn(i, this.metadata.getColumnType(i));
        }
    }

    private void configureEmptySymbol(int columnWriterIndex) {
        this.symbolMapReaders.extendAndSet(columnWriterIndex, EmptySymbolMapReader.INSTANCE);
        this.initialSymbolCounts.extendAndSet(columnWriterIndex, 0);
        this.localSymbolIds.extendAndSet(columnWriterIndex, 0);
        this.symbolMapNullFlags.extendAndSet(columnWriterIndex, false);
        this.symbolMaps.extendAndSet(columnWriterIndex, new CharSequenceIntHashMap(8, 0.5, -2));
        this.utf8SymbolMaps.extendAndSet(columnWriterIndex, new ByteCharSequenceIntHashMap(8, 0.5, -2));
    }

    private void configureSymbolMapWriter(int columnWriterIndex, CharSequence columnName, int symbolCount, long columnNameTxn) {
        if (symbolCount == 0) {
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        FilesFacade ff = this.configuration.getFilesFacade();
        Path tempPath = Path.PATH.get();
        tempPath.of(this.configuration.getRoot()).concat(this.tableToken);
        int tempPathTripLen = tempPath.length();
        this.path.trimTo(this.rootLen);
        TableUtils.offsetFileName(tempPath, columnName, columnNameTxn);
        TableUtils.offsetFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            LOG.info().$("failed to link offset file [from=").$(tempPath).$(", to=").$(this.path).$(", errno=").$(ff.errno()).I$();
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        tempPath.trimTo(tempPathTripLen);
        this.path.trimTo(this.rootLen);
        TableUtils.charFileName(tempPath, columnName, columnNameTxn);
        TableUtils.charFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            LOG.info().$("failed to link char file [from=").$(tempPath).$(", to=").$(this.path).$(", errno=").$(ff.errno()).I$();
            this.cleanupSymbolMapFiles(this.path, this.rootLen, columnName);
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        tempPath.trimTo(tempPathTripLen);
        this.path.trimTo(this.rootLen);
        BitmapIndexUtils.keyFileName(tempPath, columnName, columnNameTxn);
        BitmapIndexUtils.keyFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            LOG.info().$("failed to link key file [from=").$(tempPath).$(", to=").$(this.path).$(", errno=").$(ff.errno()).I$();
            this.cleanupSymbolMapFiles(this.path, this.rootLen, columnName);
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        tempPath.trimTo(tempPathTripLen);
        this.path.trimTo(this.rootLen);
        BitmapIndexUtils.valueFileName(tempPath, columnName, columnNameTxn);
        BitmapIndexUtils.valueFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            LOG.info().$("failed to link value file [from=").$(tempPath).$(", to=").$(this.path).$(", errno=").$(ff.errno()).I$();
            this.cleanupSymbolMapFiles(this.path, this.rootLen, columnName);
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        this.path.trimTo(this.rootLen);
        SymbolMapReaderImpl symbolMapReader = new SymbolMapReaderImpl(this.configuration, this.path, columnName, -1L, symbolCount);
        this.symbolMapReaders.extendAndSet(columnWriterIndex, symbolMapReader);
        this.symbolMaps.extendAndSet(columnWriterIndex, new CharSequenceIntHashMap(8, 0.5, -2));
        this.utf8SymbolMaps.extendAndSet(columnWriterIndex, new ByteCharSequenceIntHashMap(8, 0.5, -2));
        this.initialSymbolCounts.extendAndSet(columnWriterIndex, symbolCount);
        this.localSymbolIds.extendAndSet(columnWriterIndex, 0);
        this.symbolMapNullFlags.extendAndSet(columnWriterIndex, symbolMapReader.containsNullValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureSymbolTable() {
        boolean initialized = false;
        try {
            int denseSymbolIndex = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                int columnType = this.metadata.getColumnType(i);
                if (!ColumnType.isSymbol(columnType)) {
                    this.symbolMapReaders.extendAndSet(i, null);
                    this.symbolMaps.extendAndSet(i, null);
                    this.utf8SymbolMaps.extendAndSet(i, null);
                } else {
                    if (this.txReader == null) {
                        this.txReader = new TxReader(this.ff);
                        this.columnVersionReader = new ColumnVersionReader();
                    }
                    if (!initialized) {
                        MillisecondClock milliClock = this.configuration.getMillisecondClock();
                        long spinLockTimeout = this.configuration.getSpinLockTimeout();
                        Path path = Path.PATH2.get();
                        path.of(this.configuration.getRoot()).concat(this.tableToken).concat("_txn").$();
                        this.txReader.ofRO(path, 0);
                        path.of(this.configuration.getRoot()).concat(this.tableToken).concat("_cv").$();
                        this.columnVersionReader.ofRO(this.ff, path);
                        initialized = true;
                        long structureVersion = this.getStructureVersion();
                        do {
                            TableUtils.safeReadTxn(this.txReader, milliClock, spinLockTimeout);
                            if (this.txReader.getStructureVersion() != structureVersion) {
                                initialized = false;
                                break;
                            }
                            this.columnVersionReader.readSafe(milliClock, spinLockTimeout);
                        } while (this.txReader.getColumnVersion() != this.columnVersionReader.getVersion());
                    }
                    if (initialized) {
                        int symbolValueCount = this.txReader.getSymbolValueCount(denseSymbolIndex);
                        long columnNameTxn = this.columnVersionReader.getDefaultColumnNameTxn(i);
                        this.configureSymbolMapWriter(i, this.metadata.getColumnName(i), symbolValueCount, columnNameTxn);
                    } else {
                        this.configureSymbolMapWriter(i, this.metadata.getColumnName(i), 0, -1L);
                    }
                }
                if (columnType != 12 && columnType != -12) continue;
                ++denseSymbolIndex;
            }
        }
        finally {
            Misc.free(this.columnVersionReader);
            Misc.free(this.txReader);
        }
    }

    private MemoryMA createSecondaryMem(int columnType) {
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                return Vm.getMAInstance();
            }
        }
        return null;
    }

    private int createSegmentDir(int segmentId) {
        this.path.trimTo(this.rootLen);
        this.path.slash().put(segmentId);
        int segmentPathLen = this.path.length();
        this.rolloverSegmentLock();
        if (this.ff.mkdirs(this.path.slash$(), this.mkDirMode) != 0) {
            throw CairoException.critical(this.ff.errno()).put("Cannot create WAL segment directory: ").put(this.path);
        }
        this.path.trimTo(segmentPathLen);
        return segmentPathLen;
    }

    private void freeAndRemoveColumnPair(ObjList<MemoryMA> columns, int pi, int si) {
        MemoryMA primaryColumn = columns.getAndSetQuick(pi, NullMemory.INSTANCE);
        MemoryMA secondaryColumn = columns.getAndSetQuick(si, NullMemory.INSTANCE);
        primaryColumn.close(true, (byte)1);
        if (secondaryColumn != null) {
            secondaryColumn.close(true, (byte)1);
        }
    }

    private void freeColumns(boolean truncate) {
        if (this.columns != null) {
            int n = this.columns.size();
            for (int i = 0; i < n; ++i) {
                MemoryMA m = this.columns.getQuick(i);
                if (m == null) continue;
                m.close(truncate, (byte)1);
            }
        }
    }

    private void freeSymbolMapReaders() {
        Misc.freeObjListIfCloseable(this.symbolMapReaders);
    }

    private MemoryMA getPrimaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(WalWriter.getPrimaryColumnIndex(column));
    }

    private MemoryMA getSecondaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(WalWriter.getSecondaryColumnIndex(column));
    }

    private long getSequencerTxn() {
        long seqTxn;
        do {
            if ((seqTxn = this.sequencer.nextTxn(this.tableToken, this.walId, this.metadata.getStructureVersion(), this.segmentId, this.lastSegmentTxn)) != Long.MIN_VALUE) continue;
            this.applyMetadataChangeLog(Long.MAX_VALUE);
        } while (seqTxn == Long.MIN_VALUE);
        return seqTxn;
    }

    private boolean hasDirtyColumns(long currentTxnStartRowNum) {
        for (int i = 0; i < this.columnCount; ++i) {
            long writtenCount = this.rowValueIsNotNull.getQuick(i);
            if (writtenCount < currentTxnStartRowNum || writtenCount == Long.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    private void lockWal() {
        try {
            TableUtils.lockName(this.path);
            this.walLockFd = TableUtils.lock(this.ff, this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
        if (this.walLockFd == -1) {
            throw CairoException.critical(this.ff.errno()).put("Cannot lock table: ").put(this.path.$());
        }
    }

    private void markColumnRemoved(int columnIndex) {
        int pi = WalWriter.getPrimaryColumnIndex(columnIndex);
        int si = WalWriter.getSecondaryColumnIndex(columnIndex);
        WalWriter.freeNullSetter(this.nullSetters, columnIndex);
        this.freeAndRemoveColumnPair(this.columns, pi, si);
        this.rowValueIsNotNull.setQuick(columnIndex, Long.MAX_VALUE);
    }

    private void mayRollSegmentOnNextRow() {
        if (!this.rollSegmentOnNextRow && this.segmentRowCount >= this.configuration.getWalSegmentRolloverRowCount() || this.lastSegmentTxn > 0x7FFFFFFD) {
            this.rollSegmentOnNextRow = true;
        }
    }

    private void mkWalDir() {
        int walDirLength = this.path.length();
        if (this.ff.mkdirs(this.path.slash$(), this.mkDirMode) != 0) {
            throw CairoException.critical(this.ff.errno()).put("Cannot create WAL directory: ").put(this.path);
        }
        this.path.trimTo(walDirLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openColumnFiles(CharSequence name, int columnIndex, int pathTrimToLen) {
        try {
            MemoryMA mem1 = this.getPrimaryColumn(columnIndex);
            mem1.close(true, (byte)1);
            mem1.of(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), name), this.configuration.getDataAppendPageSize(), -1L, 5, this.configuration.getWriterFileOpenOpts(), Files.POSIX_MADV_RANDOM);
            MemoryMA mem2 = this.getSecondaryColumn(columnIndex);
            if (mem2 != null) {
                mem2.close(true, (byte)1);
                mem2.of(this.ff, TableUtils.iFile(this.path.trimTo(pathTrimToLen), name), this.configuration.getDataAppendPageSize(), -1L, 5, this.configuration.getWriterFileOpenOpts(), Files.POSIX_MADV_RANDOM);
                mem2.putLong(0L);
            }
        }
        finally {
            this.path.trimTo(pathTrimToLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewSegment() {
        try {
            ++this.segmentId;
            this.currentTxnStartRowNum = 0L;
            this.rowValueIsNotNull.fill(0, this.columnCount, -1L);
            int segmentPathLen = this.createSegmentDir(this.segmentId);
            for (int i = 0; i < this.columnCount; ++i) {
                int type = this.metadata.getColumnType(i);
                if (type > 0) {
                    String name = this.metadata.getColumnName(i);
                    this.openColumnFiles(name, i, segmentPathLen);
                    if (type != 12 || this.symbolMapReaders.size() <= 0) continue;
                    SymbolMapReader reader = this.symbolMapReaders.getQuick(i);
                    this.initialSymbolCounts.set(i, reader.getSymbolCount());
                    this.localSymbolIds.set(i, 0);
                    this.symbolMapNullFlags.set(i, reader.containsNullValue());
                    this.symbolMaps.getQuick(i).clear();
                    this.utf8SymbolMaps.getQuick(i).clear();
                    continue;
                }
                this.rowValueIsNotNull.setQuick(i, Long.MAX_VALUE);
            }
            this.segmentRowCount = 0L;
            this.metadata.switchTo(this.path, segmentPathLen);
            this.events.openEventFile(this.path, segmentPathLen);
            this.lastSegmentTxn = 0;
            LOG.info().$("opened WAL segment [path='").$(this.path).$('\'').I$();
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void releaseSegmentLock() {
        if (this.ff.close(this.segmentLockFd)) {
            this.segmentLockFd = -1;
        }
    }

    private void releaseWalLock() {
        if (this.ff.close(this.walLockFd)) {
            this.walLockFd = -1;
        }
    }

    private void removeSymbolMapReader(int index) {
        Misc.freeIfCloseable(this.symbolMapReaders.getAndSetQuick(index, null));
        this.symbolMaps.setQuick(index, null);
        this.utf8SymbolMaps.setQuick(index, null);
        this.initialSymbolCounts.set(index, -1);
        this.localSymbolIds.set(index, 0);
        this.symbolMapNullFlags.set(index, false);
        this.cleanupSymbolMapFiles(this.path, this.rootLen, this.metadata.getColumnName(index));
    }

    private void renameColumnFiles(int columnType, CharSequence columnName, CharSequence newName) {
        this.path.trimTo(this.rootLen).slash().put(this.segmentId);
        Path tempPath = Path.PATH.get().of(this.path);
        if (ColumnType.isVariableLength(columnType)) {
            int trimTo = this.path.length();
            TableUtils.iFile(this.path, columnName);
            TableUtils.iFile(tempPath, newName);
            if (this.ff.rename(this.path.$(), tempPath.$()) != 0) {
                throw CairoException.critical(this.ff.errno()).put("could not rename WAL column file [from=").put(this.path).put(", to=").put(tempPath).put(']');
            }
            this.path.trimTo(trimTo);
            tempPath.trimTo(trimTo);
        }
        TableUtils.dFile(this.path, columnName);
        TableUtils.dFile(tempPath, newName);
        if (this.ff.rename(this.path.$(), tempPath.$()) != 0) {
            throw CairoException.critical(this.ff.errno()).put("could not rename WAL column file [from=").put(this.path).put(", to=").put(tempPath).put(']');
        }
    }

    private void resetDataTxnProperties() {
        this.currentTxnStartRowNum = this.segmentRowCount;
        this.txnMinTimestamp = Long.MAX_VALUE;
        this.txnMaxTimestamp = -1L;
        this.txnOutOfOrder = false;
        this.resetSymbolMaps();
    }

    private void resetSymbolMaps() {
        int numOfColumns = this.symbolMaps.size();
        for (int i = 0; i < numOfColumns; ++i) {
            SymbolMapReader reader;
            ByteCharSequenceIntHashMap dbcsSymbolMap;
            CharSequenceIntHashMap symbolMap = this.symbolMaps.getQuick(i);
            if (symbolMap != null) {
                symbolMap.clear();
            }
            if ((dbcsSymbolMap = this.utf8SymbolMaps.getQuick(i)) != null) {
                dbcsSymbolMap.clear();
            }
            if ((reader = this.symbolMapReaders.getQuick(i)) == null) continue;
            this.initialSymbolCounts.set(i, reader.getSymbolCount());
            this.localSymbolIds.set(i, 0);
            this.symbolMapNullFlags.set(i, reader.containsNullValue());
        }
    }

    private void rollLastWalEventRecord(int newSegmentId, long uncommittedRows) {
        this.events.rollback();
        this.path.trimTo(this.rootLen).slash().put(newSegmentId);
        this.events.openEventFile(this.path, this.path.length());
        this.lastSegmentTxn = this.events.appendData(0L, uncommittedRows, this.txnMinTimestamp, this.txnMaxTimestamp, this.txnOutOfOrder);
    }

    private void rolloverSegmentLock() {
        this.releaseSegmentLock();
        int segmentPathLen = this.path.length();
        try {
            TableUtils.lockName(this.path);
            this.segmentLockFd = TableUtils.lock(this.ff, this.path);
            if (this.segmentLockFd == -1) {
                this.path.trimTo(segmentPathLen);
                throw CairoException.critical(this.ff.errno()).put("Cannot lock wal segment: ").put(this.path.$());
            }
        }
        finally {
            this.path.trimTo(segmentPathLen);
        }
    }

    private void rowAppend(ObjList<Runnable> activeNullSetters, long rowTimestamp) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.rowValueIsNotNull.getQuick(i) >= this.segmentRowCount) continue;
            activeNullSetters.getQuick(i).run();
        }
        if (rowTimestamp > this.txnMaxTimestamp) {
            this.txnMaxTimestamp = rowTimestamp;
        } else {
            this.txnOutOfOrder |= this.txnMaxTimestamp != rowTimestamp;
        }
        if (rowTimestamp < this.txnMinTimestamp) {
            this.txnMinTimestamp = rowTimestamp;
        }
        ++this.segmentRowCount;
    }

    private void setAppendPosition(long segmentRowCount) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.setColumnSize(i, segmentRowCount);
            int type = this.metadata.getColumnType(i);
            if (type <= 0) continue;
            this.rowValueIsNotNull.setQuick(i, segmentRowCount - 1L);
        }
    }

    private void setColumnNull(int columnType, int columnIndex, long rowCount) {
        if (ColumnType.isVariableLength(columnType)) {
            this.setVarColumnVarFileNull(columnType, columnIndex, rowCount);
            this.setVarColumnFixedFileNull(columnType, columnIndex, rowCount);
        } else {
            this.setFixColumnNulls(columnType, columnIndex, rowCount);
        }
    }

    private void setColumnSize(int columnIndex, long size) {
        MemoryMA mem1 = this.getPrimaryColumn(columnIndex);
        MemoryMA mem2 = this.getSecondaryColumn(columnIndex);
        int type = this.metadata.getColumnType(columnIndex);
        if (type > 0) {
            if (size > 0L) {
                long m1pos;
                switch (ColumnType.tagOf(type)) {
                    case 11: 
                    case 18: {
                        assert (mem2 != null);
                        mem2.jumpTo(size * 8L);
                        m1pos = Unsafe.getUnsafe().getLong(mem2.getAppendAddress());
                        mem2.jumpTo((size + 1L) * 8L);
                        break;
                    }
                    default: {
                        m1pos = columnIndex == this.metadata.getTimestampIndex() ? size << 4 : size << ColumnType.pow2SizeOf(type);
                    }
                }
                mem1.jumpTo(m1pos);
            } else {
                mem1.jumpTo(0L);
                if (mem2 != null) {
                    mem2.jumpTo(0L);
                    mem2.putLong(0L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFixColumnNulls(int type, int columnIndex, long rowCount) {
        MemoryMA fixedSizeColumn = this.getPrimaryColumn(columnIndex);
        long columnFileSize = rowCount * (long)ColumnType.sizeOf(type);
        fixedSizeColumn.jumpTo(columnFileSize);
        if (columnFileSize > 0L) {
            long address = TableUtils.mapRW(this.ff, fixedSizeColumn.getFd(), columnFileSize, 37);
            try {
                TableUtils.setNull(type, address, rowCount);
            }
            finally {
                this.ff.munmap(address, columnFileSize, 37);
            }
        }
    }

    private void setRowValueNotNull(int columnIndex) {
        assert (this.rowValueIsNotNull.getQuick(columnIndex) != this.segmentRowCount);
        this.rowValueIsNotNull.setQuick(columnIndex, this.segmentRowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVarColumnFixedFileNull(int columnType, int columnIndex, long rowCount) {
        MemoryMA fixedSizeColumn = this.getSecondaryColumn(columnIndex);
        long fixedSizeColSize = (rowCount + 1L) * 8L;
        fixedSizeColumn.jumpTo(fixedSizeColSize);
        if (rowCount > 0L) {
            long addressFixed = TableUtils.mapRW(this.ff, fixedSizeColumn.getFd(), fixedSizeColSize, 37);
            try {
                if (columnType == 11) {
                    Vect.setVarColumnRefs32Bit(addressFixed, 0L, rowCount + 1L);
                } else {
                    Vect.setVarColumnRefs64Bit(addressFixed, 0L, rowCount + 1L);
                }
            }
            finally {
                this.ff.munmap(addressFixed, fixedSizeColSize, 37);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVarColumnVarFileNull(int columnType, int columnIndex, long rowCount) {
        MemoryMA varColumn = this.getPrimaryColumn(columnIndex);
        long varColSize = rowCount * (long)ColumnType.variableColumnLengthBytes(columnType);
        varColumn.jumpTo(varColSize);
        if (rowCount > 0L) {
            long address = TableUtils.mapRW(this.ff, varColumn.getFd(), varColSize, 37);
            try {
                Vect.memset(address, varColSize, -1);
            }
            finally {
                this.ff.munmap(address, varColSize, 37);
            }
        }
    }

    private void switchColumnsToNewSegment(LongList newColumnFiles) {
        for (int i = 0; i < this.columnCount; ++i) {
            int newPrimaryFd = (int)newColumnFiles.get(i * 6);
            if (newPrimaryFd <= -1) continue;
            MemoryMA primaryColumnFile = this.getPrimaryColumn(i);
            long currentOffset = newColumnFiles.get(i * 6 + 1);
            long newOffset = newColumnFiles.get(i * 6 + 2);
            primaryColumnFile.jumpTo(currentOffset);
            primaryColumnFile.switchTo(newPrimaryFd, newOffset, (byte)1);
            int newSecondaryFd = (int)newColumnFiles.get(i * 6 + 3);
            if (newSecondaryFd <= -1) continue;
            MemoryMA secondaryColumnFile = this.getSecondaryColumn(i);
            currentOffset = newColumnFiles.get(i * 6 + 4);
            newOffset = newColumnFiles.get(i * 6 + 5);
            secondaryColumnFile.jumpTo(currentOffset);
            secondaryColumnFile.switchTo(newSecondaryFd, newOffset, (byte)1);
        }
    }

    SymbolMapReader getSymbolMapReader(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex);
    }

    void rollSegment() {
        try {
            this.openNewSegment();
        }
        catch (Throwable e) {
            this.distressed = true;
            throw e;
        }
    }

    private class RowImpl
    implements TableWriter.Row {
        private final StringSink tempSink = new StringSink();
        private long timestamp;

        private RowImpl() {
        }

        @Override
        public void append() {
            WalWriter.this.rowAppend(WalWriter.this.nullSetters, this.timestamp);
        }

        @Override
        public void cancel() {
            WalWriter.this.setAppendPosition(WalWriter.this.segmentRowCount);
        }

        @Override
        public void putBin(int columnIndex, long address, long len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(address, len));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBin(int columnIndex, BinarySequence sequence) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(sequence));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBool(int columnIndex, boolean value) {
            this.getPrimaryColumn(columnIndex).putBool(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putByte(int columnIndex, byte value) {
            this.getPrimaryColumn(columnIndex).putByte(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putChar(int columnIndex, char value) {
            this.getPrimaryColumn(columnIndex).putChar(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putDouble(int columnIndex, double value) {
            this.getPrimaryColumn(columnIndex).putDouble(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putFloat(int columnIndex, float value) {
            this.getPrimaryColumn(columnIndex).putFloat(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putGeoHash(int index, long value) {
            int type = WalWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoHash(index, value, type, this);
        }

        @Override
        public void putGeoHashDeg(int index, double lat, double lon) {
            int type = WalWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoHash(index, GeoHashes.fromCoordinatesDegUnsafe(lat, lon, ColumnType.getGeoHashBits(type)), type, this);
        }

        @Override
        public void putGeoStr(int index, CharSequence hash) {
            int type = WalWriter.this.metadata.getColumnType(index);
            WriterRowUtils.putGeoStr(index, hash, type, this);
        }

        @Override
        public void putInt(int columnIndex, int value) {
            this.getPrimaryColumn(columnIndex).putInt(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong(int columnIndex, long value) {
            this.getPrimaryColumn(columnIndex).putLong(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong128(int columnIndex, long lo, long hi) {
            MemoryA primaryColumn = this.getPrimaryColumn(columnIndex);
            primaryColumn.putLong(lo);
            primaryColumn.putLong(hi);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, long l0, long l1, long l2, long l3) {
            this.getPrimaryColumn(columnIndex).putLong256(l0, l1, l2, l3);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, Long256 value) {
            this.getPrimaryColumn(columnIndex).putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, CharSequence hexString) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, @NotNull CharSequence hexString, int start, int end) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString, start, end);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putShort(int columnIndex, short value) {
            this.getPrimaryColumn(columnIndex).putShort(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, char value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value, int pos, int len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value, pos, len));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStrUtf8AsUtf16(int columnIndex, DirectByteCharSequence value, boolean hasNonAsciiChars) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStrUtf8AsUtf16(value, hasNonAsciiChars));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, CharSequence value) {
            SymbolMapReader symbolMapReader = (SymbolMapReader)WalWriter.this.symbolMapReaders.getQuick(columnIndex);
            if (symbolMapReader == null) {
                throw new UnsupportedOperationException();
            }
            this.putSym0(columnIndex, value, symbolMapReader);
        }

        @Override
        public void putSym(int columnIndex, char value) {
            CharSequence str = SingleCharCharSequence.get(value);
            this.putSym(columnIndex, str);
        }

        @Override
        public void putUuid(int columnIndex, CharSequence uuidStr) {
            SqlUtil.implicitCastStrAsUuid(uuidStr, WalWriter.this.uuid);
            this.putLong128(columnIndex, WalWriter.this.uuid.getLo(), WalWriter.this.uuid.getHi());
        }

        @Override
        public void putSymUtf8(int columnIndex, DirectByteCharSequence value, boolean hasNonAsciiChars) {
            SymbolMapReader symbolMapReader = (SymbolMapReader)WalWriter.this.symbolMapReaders.getQuick(columnIndex);
            if (symbolMapReader != null) {
                ByteCharSequenceIntHashMap utf8Map = (ByteCharSequenceIntHashMap)WalWriter.this.utf8SymbolMaps.getQuick(columnIndex);
                int index = utf8Map.keyIndex(value);
                if (index < 0) {
                    this.getPrimaryColumn(columnIndex).putInt(utf8Map.valueAt(index));
                    WalWriter.this.setRowValueNotNull(columnIndex);
                } else {
                    utf8Map.putAt(index, ByteCharSequence.newInstance(value), this.putSymUtf8Slow(columnIndex, value, hasNonAsciiChars, symbolMapReader));
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private MemoryA getPrimaryColumn(int columnIndex) {
            return (MemoryA)WalWriter.this.columns.getQuick(WalWriter.getPrimaryColumnIndex(columnIndex));
        }

        private MemoryA getSecondaryColumn(int columnIndex) {
            return (MemoryA)WalWriter.this.columns.getQuick(WalWriter.getSecondaryColumnIndex(columnIndex));
        }

        private int putSym0(int columnIndex, CharSequence utf16Value, SymbolMapReader symbolMapReader) {
            int key;
            CharSequenceIntHashMap utf16Map = (CharSequenceIntHashMap)WalWriter.this.symbolMaps.getQuick(columnIndex);
            if (utf16Value != null) {
                int index = utf16Map.keyIndex(utf16Value);
                if (index > -1) {
                    key = symbolMapReader.keyOf(utf16Value);
                    if (key == -2) {
                        int initialSymCount = WalWriter.this.initialSymbolCounts.get(columnIndex);
                        key = initialSymCount + WalWriter.this.localSymbolIds.postIncrement(columnIndex);
                    }
                    utf16Map.putAt(index, Chars.toString(utf16Value), key);
                } else {
                    key = utf16Map.valueAt(index);
                }
            } else {
                key = Integer.MIN_VALUE;
                WalWriter.this.symbolMapNullFlags.set(columnIndex, true);
            }
            this.getPrimaryColumn(columnIndex).putInt(key);
            WalWriter.this.setRowValueNotNull(columnIndex);
            return key;
        }

        private int putSymUtf8Slow(int columnIndex, DirectByteCharSequence utf8Value, boolean hasNonAsciiChars, SymbolMapReader symbolMapReader) {
            return this.putSym0(columnIndex, Chars.utf8ToUtf16(utf8Value, this.tempSink, hasNonAsciiChars), symbolMapReader);
        }
    }

    private class MetadataWriterService
    implements MetadataServiceStub {
        private MetadataWriterService() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential) {
            int columnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnName);
            if (columnIndex < 0 || WalWriter.this.metadata.getColumnType(columnIndex) < 0) {
                long uncommittedRows = WalWriter.this.getUncommittedRowCount();
                if (WalWriter.this.currentTxnStartRowNum > 0L) {
                    WalWriter.this.rollUncommittedToNewSegment();
                }
                if (WalWriter.this.currentTxnStartRowNum != 0L && WalWriter.this.segmentRowCount != WalWriter.this.currentTxnStartRowNum) throw CairoException.critical(0).put("column '").put(columnName).put("' was added, cannot apply commit because of concurrent table definition change");
                long segmentRowCount = WalWriter.this.getUncommittedRowCount();
                WalWriter.this.metadata.addColumn(columnName, columnType);
                WalWriter.this.columnCount = WalWriter.this.metadata.getColumnCount();
                columnIndex = WalWriter.this.columnCount - 1;
                WalWriter.this.configureColumn(columnIndex, columnType);
                if (ColumnType.isSymbol(columnType)) {
                    WalWriter.this.configureSymbolMapWriter(columnIndex, columnName, 0, -1L);
                }
                if (!WalWriter.this.rollSegmentOnNextRow) {
                    WalWriter.this.path.trimTo(WalWriter.this.rootLen).slash().put(WalWriter.this.segmentId);
                    WalWriter.this.metadata.switchTo(WalWriter.this.path, WalWriter.this.path.length());
                    WalWriter.this.openColumnFiles(columnName, columnIndex, WalWriter.this.path.length());
                }
                if (uncommittedRows > 0L) {
                    WalWriter.this.setColumnNull(columnType, columnIndex, segmentRowCount);
                }
                LOG.info().$("added column to WAL [path=").$(WalWriter.this.path).$(Files.SEPARATOR).$(WalWriter.this.segmentId).$(", columnName=").$(columnName).I$();
                return;
            } else {
                if (WalWriter.this.metadata.getColumnType(columnIndex) != columnType) throw CairoException.nonCritical().put("column '").put(columnName).put("' already exists");
                LOG.info().$("column has already been added by another WAL [path=").$(WalWriter.this.path).$(", columnName=").$(columnName).I$();
            }
        }

        @Override
        public TableRecordMetadata getMetadata() {
            return WalWriter.this.metadata;
        }

        @Override
        public TableToken getTableToken() {
            return WalWriter.this.tableToken;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void removeColumn(CharSequence columnName) {
            int columnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnName);
            if (columnIndex <= -1) throw CairoException.nonCritical().put("column '").put(columnName).put("' does not exists");
            int type = WalWriter.this.metadata.getColumnType(columnIndex);
            if (type <= 0) return;
            if (WalWriter.this.currentTxnStartRowNum > 0L) {
                WalWriter.this.rollUncommittedToNewSegment();
            }
            if (WalWriter.this.currentTxnStartRowNum != 0L && WalWriter.this.segmentRowCount != WalWriter.this.currentTxnStartRowNum) throw CairoException.critical(0).put("column '").put(columnName).put("' was removed, cannot apply commit because of concurrent table definition change");
            int index = WalWriter.this.metadata.getColumnIndex(columnName);
            WalWriter.this.metadata.removeColumn(columnName);
            WalWriter.this.columnCount = WalWriter.this.metadata.getColumnCount();
            if (!WalWriter.this.rollSegmentOnNextRow) {
                WalWriter.this.path.trimTo(WalWriter.this.rootLen).slash().put(WalWriter.this.segmentId);
                WalWriter.this.metadata.switchTo(WalWriter.this.path, WalWriter.this.path.length());
            }
            if (ColumnType.isSymbol(type)) {
                WalWriter.this.removeSymbolMapReader(index);
            }
            WalWriter.this.markColumnRemoved(index);
            LOG.info().$("removed column from WAL [path=").$(WalWriter.this.path).$(", columnName=").$(columnName).I$();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void renameColumn(CharSequence columnName, CharSequence newColumnName) {
            int columnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnName);
            if (columnIndex <= -1) throw CairoException.nonCritical().put("column '").put(columnName).put("' does not exists");
            int columnType = WalWriter.this.metadata.getColumnType(columnIndex);
            if (columnType <= 0) return;
            if (WalWriter.this.currentTxnStartRowNum > 0L) {
                WalWriter.this.rollUncommittedToNewSegment();
            }
            if (WalWriter.this.currentTxnStartRowNum != 0L && WalWriter.this.segmentRowCount != WalWriter.this.currentTxnStartRowNum) throw CairoException.critical(0).put("column '").put(columnName).put("' was removed, cannot apply commit because of concurrent table definition change");
            WalWriter.this.metadata.renameColumn(columnName, newColumnName);
            if (!WalWriter.this.rollSegmentOnNextRow) {
                WalWriter.this.path.trimTo(WalWriter.this.rootLen).slash().put(WalWriter.this.segmentId);
                WalWriter.this.metadata.switchTo(WalWriter.this.path, WalWriter.this.path.length());
                WalWriter.this.renameColumnFiles(columnType, columnName, newColumnName);
            }
            LOG.info().$("renamed column in wal [path=").$(WalWriter.this.path).$(", columnName=").$(columnName).$(", newColumnName=").$(newColumnName).I$();
        }
    }

    private class MetadataValidatorService
    implements MetadataServiceStub {
        public long structureVersion;

        private MetadataValidatorService() {
        }

        @Override
        public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential) {
            if (!TableUtils.isValidColumnName(columnName, columnName.length())) {
                throw CairoException.nonCritical().put("invalid column name: ").put(columnName);
            }
            if (WalWriter.this.metadata.getColumnIndexQuiet(columnName) > -1) {
                throw CairoException.nonCritical().put("duplicate column name: ").put(columnName);
            }
            if (columnType <= 0) {
                throw CairoException.nonCritical().put("invalid column type: ").put(columnType);
            }
            ++this.structureVersion;
        }

        @Override
        public TableRecordMetadata getMetadata() {
            return WalWriter.this.metadata;
        }

        @Override
        public TableToken getTableToken() {
            return WalWriter.this.tableToken;
        }

        @Override
        public void removeColumn(CharSequence columnName) {
            int columnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnName);
            if (columnIndex < 0 || WalWriter.this.metadata.getColumnType(columnIndex) < 0) {
                throw CairoException.nonCritical().put("cannot remove column, column does not exists [table=").put(WalWriter.this.tableToken.getTableName()).put(", column=").put(columnName).put(']');
            }
            if (columnIndex == WalWriter.this.metadata.getTimestampIndex()) {
                throw CairoException.nonCritical().put("cannot remove designated timestamp column [table=").put(WalWriter.this.tableToken.getTableName()).put(", column=").put(columnName);
            }
            ++this.structureVersion;
        }

        @Override
        public void renameColumn(CharSequence columnName, CharSequence newName) {
            int columnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnName);
            if (columnIndex < 0) {
                throw CairoException.nonCritical().put("cannot rename column, column does not exists [table=").put(WalWriter.this.tableToken.getTableName()).put(", column=").put(columnName).put(']');
            }
            if (columnIndex == WalWriter.this.metadata.getTimestampIndex()) {
                throw CairoException.nonCritical().put("cannot rename designated timestamp column [table=").put(WalWriter.this.tableToken.getTableName()).put(", column=").put(columnName).put(']');
            }
            int columnIndexNew = WalWriter.this.metadata.getColumnIndexQuiet(newName);
            if (columnIndexNew > -1) {
                throw CairoException.nonCritical().put("cannot rename column, column with the name already exists [table=").put(WalWriter.this.tableToken.getTableName()).put(", newName=").put(newName).put(']');
            }
            if (!TableUtils.isValidColumnName(newName, newName.length())) {
                throw CairoException.nonCritical().put("invalid column name: ").put(newName);
            }
            ++this.structureVersion;
        }

        public void startAlterValidation() {
            this.structureVersion = WalWriter.this.metadata.getStructureVersion();
        }
    }
}

