/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.configuration;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.toolkit.tls.configuration.InstanceIdentifier;

public class InstanceDefinition {
    private final InstanceIdentifier instanceIdentifier;
    private final int number;
    private final String keyStorePassword;
    private final String keyPassword;
    private final String trustStorePassword;

    public InstanceDefinition(InstanceIdentifier instanceIdentifier, int number, String keyStorePassword, String keyPassword, String trustStorePassword) {
        this.number = number;
        this.instanceIdentifier = instanceIdentifier;
        this.keyStorePassword = keyStorePassword;
        this.keyPassword = keyPassword;
        this.trustStorePassword = trustStorePassword;
    }

    public static List<InstanceDefinition> createDefinitions(Stream<String> fullHostNameExpressions, Stream<String> currentHostnameExpressions, Supplier<String> keyStorePasswords, Supplier<String> keyPasswords, Supplier<String> trustStorePasswords) {
        if (fullHostNameExpressions == null) {
            return InstanceIdentifier.createIdentifiers(currentHostnameExpressions).map(id -> InstanceDefinition.createDefinition(id, id.getNumber(), keyStorePasswords, keyPasswords, trustStorePasswords)).collect(Collectors.toList());
        }
        Map<InstanceIdentifier, Integer> orderMap = InstanceIdentifier.createOrderMap(fullHostNameExpressions);
        return InstanceIdentifier.createIdentifiers(currentHostnameExpressions).map(id -> {
            Integer number = (Integer)orderMap.get(id);
            if (number == null) {
                throw new IllegalArgumentException("Unable to find " + id.getHostname() + " in specified " + "globalPortSequence" + " expression(s).");
            }
            return InstanceDefinition.createDefinition(id, number, keyStorePasswords, keyPasswords, trustStorePasswords);
        }).collect(Collectors.toList());
    }

    protected static InstanceDefinition createDefinition(InstanceIdentifier instanceIdentifier, int number, Supplier<String> keyStorePasswords, Supplier<String> keyPasswords, Supplier<String> trustStorePasswords) {
        String keyStorePassword = null;
        if (keyStorePasswords != null) {
            keyStorePassword = keyStorePasswords.get();
        }
        String keyPassword = keyPasswords == null ? keyStorePassword : keyPasswords.get();
        String trustStorePassword = null;
        if (trustStorePasswords != null) {
            trustStorePassword = trustStorePasswords.get();
        }
        return new InstanceDefinition(instanceIdentifier, number, keyStorePassword, keyPassword, trustStorePassword);
    }

    public String getHostname() {
        return this.instanceIdentifier.getHostname();
    }

    public int getNumber() {
        return this.number;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public InstanceIdentifier getInstanceIdentifier() {
        return this.instanceIdentifier;
    }
}

