/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.crypto;

import java.io.IOException;
import org.apache.nifi.registry.properties.util.NiFiRegistryBootstrapUtils;
import org.apache.nifi.registry.security.crypto.CryptoKeyProvider;
import org.apache.nifi.registry.security.crypto.MissingCryptoKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapFileCryptoKeyProvider
implements CryptoKeyProvider {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapFileCryptoKeyProvider.class);
    private final String bootstrapFile;

    public BootstrapFileCryptoKeyProvider(String bootstrapFilePath) {
        if (bootstrapFilePath == null) {
            throw new IllegalArgumentException(BootstrapFileCryptoKeyProvider.class.getSimpleName() + " cannot be initialized with null bootstrap file path.");
        }
        this.bootstrapFile = bootstrapFilePath;
    }

    public String getBootstrapFile() {
        return this.bootstrapFile;
    }

    @Override
    public String getKey() throws MissingCryptoKeyException {
        try {
            return NiFiRegistryBootstrapUtils.extractKeyFromBootstrapFile(this.bootstrapFile);
        }
        catch (IOException ioe) {
            String errMsg = "Loading the master crypto key from bootstrap file '" + this.bootstrapFile + "' failed due to IOException.";
            logger.warn(errMsg);
            throw new MissingCryptoKeyException(errMsg, ioe);
        }
    }

    @Override
    public String toString() {
        return "BootstrapFileCryptoKeyProvider{bootstrapFile='" + this.bootstrapFile + '\'' + '}';
    }
}

