/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.userinfo;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.web.security.oidc.OidcConfigurationException;
import org.apache.nifi.web.security.oidc.userinfo.StandardOidcUser;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class StandardOidcUserService
extends OidcUserService {
    private final List<String> userClaimNames;
    private final List<IdentityMapping> userIdentityMappings;

    public StandardOidcUserService(List<String> userClaimNames, List<IdentityMapping> userIdentityMappings) {
        this.userClaimNames = Objects.requireNonNull(userClaimNames, "User Claim Names required");
        this.userIdentityMappings = Objects.requireNonNull(userIdentityMappings, "User Identity Mappings required");
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = super.loadUser(userRequest);
        String userClaimName = this.getUserClaimName(oidcUser);
        String claim = oidcUser.getClaimAsString(userClaimName);
        String name = IdentityMappingUtil.mapIdentity((String)claim, this.userIdentityMappings);
        return new StandardOidcUser(oidcUser.getAuthorities(), oidcUser.getIdToken(), oidcUser.getUserInfo(), userClaimName, name);
    }

    private String getUserClaimName(OidcUser oidcUser) {
        Optional<String> userClaimNameFound = this.userClaimNames.stream().filter(arg_0 -> ((OidcUser)oidcUser).hasClaim(arg_0)).findFirst();
        return userClaimNameFound.orElseThrow(() -> {
            String message = String.format("User Claim Name not found in configured Token Claims %s", this.userClaimNames);
            return new OidcConfigurationException(message);
        });
    }
}

