/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.provider;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.nifi.web.security.jwt.provider.IssuerProvider;

public class StandardIssuerProvider
implements IssuerProvider {
    private static final String URI_FORMAT = "https://%s:%d";
    private final URI issuer;

    public StandardIssuerProvider(String host, int port) {
        String resolvedHost = this.getResolvedHost(host);
        String uri = String.format(URI_FORMAT, resolvedHost, port);
        this.issuer = URI.create(uri);
    }

    @Override
    public URI getIssuer() {
        return this.issuer;
    }

    private String getResolvedHost(String host) {
        String resolvedHost = host == null || host.isEmpty() ? this.getLocalHost() : host;
        return resolvedHost;
    }

    private String getLocalHost() {
        try {
            InetAddress localHostAddress = InetAddress.getLocalHost();
            return localHostAddress.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Failed to resolve local host address", e);
        }
    }
}

